import random
from dataclasses import dataclass
from itertools import chain, combinations
from typing import List, Set

from cardgame.abc.CardABC import CardABC


@dataclass
class SetCard(CardABC):
    U = {1, 2, 3, 4, 5, 6, 7}

    _set: Set[int]

    def __str__(self) -> str:
        return f"[{self._set}]"

    def __ge__(self, other: CardABC) -> bool:
        if not isinstance(other, SetCard):
            raise TypeError(f"Cannot compare SetCard with {type(other)}")
        return self._set >= other._set

    @classmethod
    def get_random_card(cls) -> "SetCard":
        return SetCard(set(filter(lambda _: random.choice([True, False]), cls.U)))

    @classmethod
    def get_all_cards(cls) -> List["CardABC"]:
        s = list(cls.U)
        subsets = chain.from_iterable(combinations(s, r) for r in range(len(s) + 1))
        return list(map(cls, subsets))
