from typing import List, Optional, Tuple, Type

from cardgame.abc.CardABC import CardABC
from cardgame.abc.TrickABC import TrickABC
from cardgame.abc.WinnerStrategyABC import WinnerStrategyABC


class Trick(TrickABC):
    _stack: List[Tuple[CardABC, int]]
    _max_card: Optional[Tuple[CardABC, int]]
    _winner_strategy: Type[WinnerStrategyABC]

    def __init__(self, winner_strategy: Type[WinnerStrategyABC]):
        self.reset()
        self._winner_strategy = winner_strategy

    def play_as_lowest(self, player: int, card: CardABC) -> bool:
        self._stack.append((card, player))
        return True

    def play_normal(self, player: int, card: CardABC) -> bool:
        if self._max_card is None or card >= self._max_card[0]:
            self._stack.append((card, player))
            # Keep the last max card
            self._max_card = (card, player)
            return True
        return False

    def winner(self) -> Optional[int]:
        if not self._stack:
            return None
        return self._winner_strategy.choose_winner(self._stack)

    def size(self) -> int:
        return len(self._stack)

    def cards(self) -> List[CardABC]:
        return [x[0] for x in self._stack]

    def reset(self) -> None:
        self._stack = list()
        self._max_card = None

    def started_by(self) -> Optional[int]:
        if self._stack:
            return self._stack[0][1]
        else:
            return None
