from typing import Sequence, Tuple

from cardgame.abc.CardABC import CardABC
from cardgame.abc.WinnerStrategyABC import WinnerStrategyABC


class WinnerStrategyLast(WinnerStrategyABC):
    @staticmethod
    def choose_winner(cards: Sequence[Tuple[CardABC, int]]) -> int:
        carditer = iter(cards)
        max_card, winner = next(carditer)
        for card, player in carditer:
            if card >= max_card:
                max_card = card
                winner = player
        return winner
