from abc import ABC, abstractmethod
from typing import List


class CardABC(ABC):
    @abstractmethod
    def __str__(self) -> str:
        ...

    @abstractmethod
    def __ge__(self, other: "CardABC") -> bool:
        ...

    @classmethod
    @abstractmethod
    def get_random_card(cls) -> "CardABC":
        ...

    @classmethod
    @abstractmethod
    def get_all_cards(cls) -> List["CardABC"]:
        ...
