from abc import ABC, abstractmethod, abstractproperty
from typing import List, Optional, Set

from cardgame.abc.GameStateABC import GameStateABC
from cardgame.abc.HandABC import HandABC
from cardgame.abc.TrickABC import TrickABC


class GameABC(ABC):
    trick_started_by: Optional[int]

    @abstractmethod
    def __init__(self, hands: List[HandABC], trick: TrickABC, total_tricks: int):
        ...

    @abstractproperty
    def number_of_players(self) -> int:
        ...

    @abstractmethod
    def play(self, player: int, card_number: int) -> bool:
        ...

    @abstractmethod
    def state(self) -> GameStateABC:
        ...

    @abstractmethod
    def winners(self) -> Optional[Set[int]]:
        ...
