from abc import ABC, abstractmethod

from cardgame.abc.GameStateABC import GameStateABC
from cardgame.GameType import GameType


class GameServerABC(ABC):
    @abstractmethod
    def play(self, player: int, card_number: int) -> bool:
        ...

    @abstractmethod
    def get_state(self, player: int) -> GameStateABC:
        ...

    @abstractmethod
    def new_game(self, game_type: GameType, player_count: int) -> bool:
        ...
