from abc import ABC, abstractmethod
from typing import List, Sequence

from cardgame.abc.CardABC import CardABC
from cardgame.abc.TrickABC import TrickABC


class HandABC(ABC):
    _cards: List[CardABC]

    @abstractmethod
    def __init__(self, player: int, trick: TrickABC, cards: Sequence[CardABC]):
        ...

    @abstractmethod
    def play(self, card_number: int) -> bool:
        ...

    @abstractmethod
    def cards(self) -> List[CardABC]:
        ...

    @abstractmethod
    def is_lowest(self, card_number: int) -> bool:
        ...
