from abc import ABC, abstractmethod
from typing import List, Optional, Type

from cardgame.abc.CardABC import CardABC
from cardgame.abc.WinnerStrategyABC import WinnerStrategyABC


class TrickABC(ABC):
    @abstractmethod
    def __init__(self, winner_strategy: Type[WinnerStrategyABC]):
        ...

    @abstractmethod
    def play_as_lowest(self, player: int, card: CardABC) -> bool:
        ...

    @abstractmethod
    def play_normal(self, player: int, card: CardABC) -> bool:
        ...

    @abstractmethod
    def winner(self) -> Optional[int]:
        ...

    @abstractmethod
    def size(self) -> int:
        ...

    @abstractmethod
    def cards(self) -> List[CardABC]:
        ...

    @abstractmethod
    def reset(self) -> None:
        ...

    @abstractmethod
    def started_by(self) -> Optional[int]:
        ...
