import pytest
from cardgame.Card import Card


def test_card_compare():
    assert Card("♠", 10) >= Card("♠", 10)
    assert Card("♠", 10) >= Card("♦", 9)
    assert Card("♦", 10) >= Card("♥", 0)
    assert not Card("♣", 10) >= Card("♥", 11)

    with pytest.raises(TypeError):
        Card("♣", 9) >= 5


def test_card_str():
    s = str(Card("♣", 9))
    assert "♣" in s
    assert "J" in s


def test_all_cards():
    ac = Card.get_all_cards()
    assert len(ac) == 52
