import pytest
from cardgame.abc.CardABC import CardABC
from cardgame.abc.GameABC import GameABC
from cardgame.abc.HandABC import HandABC
from cardgame.abc.TrickABC import TrickABC
from cardgame.Card import Card
from cardgame.Game import Game
from cardgame.Hand import Hand
from cardgame.Trick import Trick
from cardgame.WinnerStrategyLast import WinnerStrategyLast


@pytest.fixture
def game():
    trick = Trick(WinnerStrategyLast)
    hands = [
        Hand(
            0,
            trick,
            [
                Card(suit="♣", rank=2),
                Card(suit="♣", rank=5),
                Card(suit="♠", rank=12),
            ],
        ),
        Hand(
            1,
            trick,
            [
                Card(suit="♣", rank=8),
                Card(suit="♣", rank=12),
                Card(suit="♦", rank=7),
            ],
        ),
        Hand(
            2,
            trick,
            [
                Card(suit="♦", rank=9),
                Card(suit="♥", rank=2),
                Card(suit="♦", rank=9),
            ],
        ),
    ]

    return Game(hands, trick, total_tricks=2)


def test_player_count(game: Game):
    assert game.number_of_players == 3


def test_state(game: Game):
    assert len(game.state().cards) == 3


def test_first_turn(game: Game):
    for p in range(1, 3):
        for i in range(6):
            assert not game.play(p, i)
    assert game.play(0, 0)  # First player can play any card


def test_full_game(game: Game):
    assert game.play(0, 0)
    assert game.play(1, 0)
    assert game.play(2, 0)

    assert not game.ended
    assert game.winners() is None

    assert game.play(0, 1)
    assert game.play(1, 0)
    assert game.play(2, 0)

    assert game.ended
    assert game.winners() == {0}


def test_bad_card(game: Game):
    assert game.play(0, 2)
    gs = game.state()
    assert not game.play(1, 0)
    assert game.state() == gs

    assert game.play(1, 2)  # lowest

    gs = game.state()
    assert not game.play(2, 0)
    assert game.state() == gs
