import pytest
from cardgame import GameServer, GameType
from cardgame.GameServer import NotInGameException


def test_create_standard():
    gs = GameServer()
    assert gs.new_game() is True


def test_create_overwrite():
    gs = GameServer()
    gs.new_game()
    g1 = gs.game

    assert gs.new_game() == True
    assert gs.game is not g1


def test_no_game_play():
    with pytest.raises(NotInGameException):
        gs = GameServer()
        gs.play(0, 0)


def test_no_game_get_state():
    with pytest.raises(NotInGameException):
        gs = GameServer()
        gs.get_state(0)
