from cardgame.DealerFactory import DealerFactory
from cardgame.GameState import GameState
from cardgame.GameType import GameType


def make_random_state():
    g = DealerFactory.get_dealer(GameType.Standard).create_game(4)
    return g.state()


def test_player_view():
    state = make_random_state()
    for i in range(len(state.cards)):
        ps = state.player_view(i)
        assert ps.cards[0] == state.cards[i]
        assert all(x is None for x in ps.cards[1:])
        assert ps.trick == state.trick
