import random

import pytest
from cardgame.Hand import Hand


def make_random_hand():
    return Hand(0, FakeTrick(), [random.randint(1, 10) for _ in range(5)])


class FakeTrick:
    pass


class Flag:
    def __init__(self, value=False):
        self.value = value

    def set(self):
        self.value = True

    def clear(self):
        self.value = False

    def is_set(self):
        return self.value


@pytest.fixture
def faketrick():
    return FakeTrick()


@pytest.fixture
def hand(faketrick, cards):
    return Hand(0, faketrick, cards)


def test_cards(hand, cards):
    assert hand.cards() == cards


def test_is_lowest(hand, cards):
    for i in range(len(cards)):
        low = hand.is_lowest(i)
        assert not (i == 0 or i == 7) ^ low


def test_play_player_id(cards):
    for player in range(5):

        class FT:
            def play_normal(p, _):
                assert p == player

        hand = Hand(player, FT, cards)
        hand.play(1)


def test_play_normal_succ(cards):
    flag = Flag()

    class FT:
        def play_normal(_, card):
            assert card == cards[1]
            flag.set()
            return True

        def play_as_lowest(player, card):
            assert False

    hand = Hand(0, FT, cards)
    hand.play(1)
    assert flag.is_set()
    assert hand.cards() == cards[0:1] + cards[2:]


def test_play_normal_fail_notlowest(cards):
    flag = Flag()

    class FT:
        def play_normal(_, card):
            assert card == cards[1]
            flag.set()
            return False

        def play_as_lowest(player, card):
            assert False

    hand = Hand(0, FT, cards)
    assert hand.play(1) is False
    assert hand.cards() == cards
    assert flag.is_set()


def test_play_normal_fail_lowest_succ(cards):
    flag = Flag()
    flag2 = Flag()

    class FT:
        def play_normal(_, card):
            assert card == cards[0]
            flag.set()
            return False

        def play_as_lowest(player, card):
            flag2.set()
            return True

    hand = Hand(0, FT, cards)

    assert hand.is_lowest(0)
    assert hand.play(0) is True
    assert hand.cards() == cards[1:]
    assert flag.is_set()
    assert flag2.is_set()


def test_play_normal_fail_lowest_fail(cards):
    flag = Flag()
    flag2 = Flag()

    class FT:
        def play_normal(_, card):
            assert card == cards[0]
            flag.set()
            return False

        def play_as_lowest(player, card):
            flag2.set()
            return False

    hand = Hand(0, FT, cards)

    assert hand.is_lowest(0)
    assert hand.play(0) is False
    assert hand.cards() == cards
    assert flag.is_set()
    assert flag2.is_set()


def test_hand_bounds(hand):
    assert not hand.play(len(hand._cards))
