import pytest
from typing import List
from cardgame.abc.CardABC import CardABC
from cardgame.abc.DealerFactoryABC import DealerFactoryABC
from cardgame.abc.DealerABC import DealerABC
from cardgame.Card import Card
from cardgame.DealerGeneric import DealerGeneric
from cardgame.Game import Game
from cardgame.GameServer import GameServer
from cardgame.GameType import GameType
from cardgame.Hand import Hand
from cardgame.Trick import Trick
from cardgame.WinnerStrategyLast import WinnerStrategyLast

class FakeDealerFactory(DealerFactoryABC):
    @staticmethod
    def get_dealer(game_type: GameType) -> DealerABC:
        def mocked_shuffle(deck: List[CardABC]):
            deck.clear()
            deck.extend([Card("♠", "2"), 
                         Card("♠", "5"),
                         Card("♠", "4"),
                         Card("♠", "A"),
                         ])
            
        
        return DealerGeneric("Fake game", 
                             Game,
                             Hand,
                             Card,
                             Trick,
                             WinnerStrategyLast,
                             2,
                             mocked_shuffle)



def test_integration():
    server = GameServer(FakeDealerFactory())
    server.new_game(GameType.Standard, 2)
    assert server.play(0, 0) is True
    assert server.play(1, 0) is False
    assert server.play(1, 1) is True
    
