import pytest
from cardgame.Hand import Hand
from cardgame.SetCard import SetCard


def test_card_compare():
    assert SetCard({1, 2, 3}) >= SetCard({1, 2, 3})
    assert SetCard({1, 2, 3, 4}) >= SetCard({1, 2, 3})
    assert SetCard({1}) >= SetCard(set())
    assert not SetCard({1, 2, 4}) >= SetCard({1, 2, 3})
    assert not SetCard({5, 6, 7}) >= SetCard({1, 2, 3})

    with pytest.raises(TypeError):
        SetCard({1, 2}) >= 5


setcards = [
    SetCard({1, 2, 3, 4, 5, 6}),
    SetCard({1, 3}),
    SetCard({4, 7}),
    SetCard({3, 4, 7}),
    SetCard({2, 3, 5, 6}),
    SetCard({1, 3, 5, 6}),
]


def test_card_str():
    assert "1, 2, 5" in str(SetCard({1, 2, 5}))


def test_hand_is_lowest():
    h = Hand(0, None, setcards)
    assert not h.is_lowest(0)
    assert h.is_lowest(1)
    assert h.is_lowest(2)
    assert not h.is_lowest(3)
    assert h.is_lowest(4)
    assert not h.is_lowest(5)


def test_all():
    ac = SetCard.get_all_cards()
    assert len(ac) == 2 ** len(SetCard.U)
