from orm import LibraryUser, LibraryBook, Reservations
from library import Reservation

#We can choose our way how to read
class LibraryUsersPerVer1:
    def __init__(self, session):
        self.session = session
    def __contains__(self, name):
        return self.session.query(LibraryUser.name).filter(LibraryUser.name==name).scalar() is not None
    def add(self, name):
        new_user = LibraryUser(name=name)
        self.session.add(new_user)

#We can choose our way how to read
class LibraryUsersPerVer2:
    def __init__(self, session):
        self.session = session
        self.users = set(row.name for row in session.query(LibraryUser.name))
    def __contains__(self, name):
        return name in self.users
    def add(self, name):
        new_user = LibraryUser(name=name)
        self.session.add(new_user)
        self.users.add(name)
        
        
class LibraryBooksPer:
    def __init__(self, session):
        self.session = session
#    def __getitem__(self, name):
#        return self.session.query(LibraryBook.count).filter(LibraryBook.name==name).scalar()
    def __setitem__(self, name, count):
        book = self.session.query(LibraryBook).filter(LibraryBook.name==name).scalar()
        book.count = count
    def get(self, name, default):
        res = self.session.query(LibraryBook).filter(LibraryBook.name==name).scalar()
        if res == None:
              res = LibraryBook(name=name, count=default)
              self.session.add(res)
        return res.count
#Note that we require here that the ORM is quite smart especially if we add a book and then run get

class LibraryReservationsPer:        
    def __init__(self, session):
        self.session = session
        self.reservations = [ReservationPer(r) for r in session.query(Reservations)]
        #This is my biggest concern, this sort criterion must be the same in Library
        self.sort(key=lambda x:x.from_)                             
    def __iter__(self):
        for elem in self.reservations:
            yield elem
     
    def sort(self, key=lambda x:x.from_):
        self.reservations.sort(key=key)
    
    def __iadd__(self, other):
        for x in other:
            self.session.add(x.r)
        self.reservations+=other
        return self
            
class ReservationPer(Reservation):
    def __init__(self, r):
        self.r = r        
    @property
    def _from(self):
        return self.r.from_
    @property
    def _to(self):
        return self.r.to
    @property
    def _book(self):
        return self.r.book
    @property
    def _for(self):
        return self.r.for_
    @_for.setter
    def _for(self, new):
        self.r.for_ = new

def ReservationFactory(from_, to, book, for_):
    return ReservationPer(Reservations(from_= from_,to=to, book=book, for_=for_))
        
