##ORM use example

In this example we extent the Library and the Reservation class in such a way that it persists in a database using SQLAlchemy ORM.

To do this we needed only one change. We needed more flexibility. All the lists, sets and dictionaries present in teh Library class are a reasonable concern for persistence. They are not just simple objects. Thus we have to inject these classes into the Library. 

I want to stress that typically in industry, when you use ORM you build your business logic on ORM. This is theoretically not right, but in practice is a bit easier thus very often the easier approach wins (despite significant drawbacks). This example is, to a degree experimental, and there probably are other ways how to achieve this easier (I am a SQLAlchemy Beginner).

In this example we extend the business logic. Thus the business logic is the base. The approach is verbose. But note that there are various ways to approach how to persist your object (see e.g. LibraryUsersPerVer1 vs LibraryUsersPerVer2). SQLAlchemy ORM forces you to choose your way. Some other ORM framework would do this choice for you and thus you could avoid writing these some of the stuff (but this comes at the cost of flexibility, this may be especially significant in projects that handle a lot of data when performance comes into play).

The example consists of several parts

- `orm.py`: defines database tables and the corresponding basic objects.
- `createtables.py`: initializes the database and creates the tables
- `library.py`: almost exactly the file from the solution of Assignment 2 (just some extra injections of sets, lists, and dicts).
-  `library_perstist.py`: Defines persistent versions of Reservation, users set, books dictionary, and reservations list. Note that we need not to persist the Library when it is singleton.
- `use_db.py`: A simple integration test. OK it is a bit sloppy. You need to remove the database file, create tables and the run it each time.