from itertools import cycle, combinations, compress, islice

#this are iterators
range(1,5)
zip([11,12,13], range(5))

#itertools has lot of tools
list(islice(cycle(range(1,5)),22,31))

for i in combinations([1, 2, 3], 2):
  print(i)

''.join(compress('ABCDEF', [1,0,1,0,1,1]))

#how to write my fancy iterator
class Counter:
  def __init__(self, low, high):
    self.current = low
    self.high = high
  def __iter__(self):
    return self
  def __next__(self): 
    if self.current > self.high:
      raise StopIteration
    else:
      self.current += 1
      return self.current - 1

for c in Counter(3, 8):
    print(c)


#Another way, now it looks stupid, but it may be sensible
class Counter:
  def __init__(self, low, high):
    self.low = low
    self.high = high
  def __iter__(self):
    class my_iter:
      def __init__(self, low, high):
        self.current = low
        self.high = high
      def __iter__(self):
        return self
      def __next__(self): 
        if self.current > self.high:
          raise StopIteration
        else:
          self.current += 1
          return self.current - 1
    return my_iter(self.low,self.high)

for c in Counter(3, 8):
    print(c)

#wait, this is unnecessary hard, generators are great
def counter(low, high):
  while(low<high):
    yield low
    low=low+1

for c in counter(3, 8):
    print(c)

a=counter(1,5)
a
a.__next__()
a.__next__()
a.__next__()
a.__next__()
a.__next__()

list(islice(counter(1,5),2,4))


#probably, you should be writing generators most of the times
# but wait
def counter(start=0):
  while(1):
    a=yield start
    if a is not None:
      start=a
    else:
      start=start+1  

a=counter(1)
next(a)
a.send(15)
next(a)
next(a)
next(a)
a.send(15)


#... write only "generator" ... coroutine
def writer():
  while(1):
    a=(yield)
    print(a)

a=writer()
next(a)
a.send("ako")
a.send("preco")


#Generators that both read and write are not recommended but just for the sake of an example
#Suppose that we do not like that is not nice that .send() returns next value
#Lets write a decorator that adds .just_send() method
def just_send(g):
  def g2(*args,**kwargs):
    class gen:
      def __init__(self,*args,**kwargs):
        self.gen=g(*args,**kwargs)
        self.has_data=0
        self.buf=None
      def __iter__(self):
        return self
      def __next__(self):
        if self.has_data==1:
          self.has_data=0
          return self.buf
        else:
          return self.gen.__next__()
      def just_send(self, a):
        self.has_data=1
        self.buf=self.gen.send(a)
        return
      def send(self, a):
        return self.gen.send(a)
    return gen(*args,**kwargs)
  return g2

#if we already have a function, we can apply decorator directly  
counter2=just_send(counter)  

a=counter2()
next(a)
next(a)
next(a)
a.send(15)
next(a)
next(a)
a.just_send(0)
next(a)
next(a)
a.just_send(10)
next(a)
  
  
for i in counter2():
  print(i)
  if i>10:
    break
  



#Exercise1
#let us represent a graph as follows
[[1,2,3], [0], [1], [2]]
#this graph has four vertices (indexed continuously from 0) write a generator that generates its edges. Be careful that each edge is generated just once.


