class Student:
    def __init__(self, known_rooms):
        self.known_rooms = known_rooms #map string -> Clasroom
        self.in_room = None
    def visit_room(self, room_to_visit):
        #no checking, I just want to demonstrate a scenarion
        print("I am entering the room.")
        self.in_room = self.known_rooms[room_to_visit]
        self.in_room.student_enters_the_room(self) 
        print("I am looking for a free chair")
        for desk in self.in_room.get_desks():
            emptychairs = desk.get_empty_chairs()
            if emptychairs:
                 print("I am sitting down")
                 my_chair = emptychairs[0]
                 my_chair.sit_on(self)
                 break
        print("I am leaving the chair")
        my_chair.leave()
        print("I am leaving the room.")
        self.in_room.student_leaves_the_room(self) 
        self.in_room = None

class Classroom:
    def __init__(self, desks):
        self.desks = desks
        self.students = []
    def student_enters_the_room(self, who):
        self.students.append(who)
        print("CR: A student enters the room.")
    def student_leaves_the_room(self, who):
        self.students.remove(who)
        print("CR: A student leaves the room.")
    def get_desks(self):      
        print("CR: A student is looking for a desk.")
        return self.desks

class Desk:
    def __init__(self, chairs, computer):
        self.chairs = chairs
        self.computer = computer
    def get_empty_chairs(self):      
        print("DE: A student is looking for a chair.")
        return [ch for ch in self.chairs if ch.is_free()] 

class Chair:
    def __init__(self):
        self.sits_here = None
    def is_free(self):
        print("CH: Somebody is looking if I am free.")        
        return self.sits_here is None
    def sit_on(self, who):
        print("CH: Somebody sat on me.")        
        self.sits_here = who    
    def leave(self):
        print("CH: I am free now.")        
        self.sits_here = None


c1 = Chair()
d1 = Desk([c1], None)
cr = Classroom([d1])
st = Student({'room1': cr})
st.visit_room('room1')

