import sys

from container import Container
from dependency_injector import providers

from a import A
from b import B
from c import C
from d import D

#ordinary approach
#cinstance = C(D("d1"))
#binstance = B(cinstance, D("d2"))
#ainstance = A(binstance, cinstance)

container = Container()
container.wire(modules=[sys.modules[__name__]])
    
d = D()
d.do_stuff()
print("Level1 done.")

c = C()
c.do_stuff()
print("Level2 done.")

b = B()
b.do_stuff()
print("Level3 done.")

a = A()
a.do_stuff()
print("Level4 done.")

print(a.b.c is a.c)
print(a.b.d is not a.c.d)

