#we have various collections
for element in [1, 2, 3]: #list
    print(element)

for element in (1, 2, 3): #tuple
    print(element)

for key in {'one':1, 'two':2}: #dict
    print(key)

for char in "123": #string
    print(char)

for i,element in enumerate((1, 2, 3)): #tuple
    print(i)
    print(element)


"abc"[2]
{'one':1, 'two':2}['one']
(1, 2, 3)[1]
[1, 2, 3][1]

#btw this is not a tuple
(1)
#but this is
(1,)


#some collections are mutable
{'one':1, 'two':2}['one']=3
[1, 2, 3][1]=3


#some some are not
"abc"[2]='d'
(1, 2, 3)[1]=3
#mutability is actually a big thing

#we may concatenate 
[1, 2, 3]+[4, 5]
(1, 2, 3)+(4,5)
"abc"+'de'

#and by combining all the stuff we can make very complex structure
{1:[{'name':'Jozo', 'id':1234}, {'name':'Fero', 'id':1235}], 2:[]}

#it is easy to create some lists
for i in range(3):
  print(i)

#but not everything that is a collection needs to be evaluated right away
#we will speak about generators later, range is such an object
range(3)
list(range(3))



#ok, list comprehensions now
[x**2 for x in range(5)]
[x for x in [1,2,3,5,7,9] if x in [2,3,5,6,7,8]]
[(x,y) for x in [1,2,3,5,7,9] for y in [1, 2]]

#or we can apply function
def sqr(i):
  return i*i

#note the list here, map would be evaluated lazily
list(map(sqr, range(5)))
#but this is preferred
[sqr(x) for x in range(5)]


#and we can use anonymous functions
list(map(lambda x: x**2, range(10)))


#two other functions  common in functional programming are filter and reduce, partial
list(filter(lambda x: x%2==0, map(lambda x: x**2, range(10))))
#hard to read?
iseven = lambda x: x%2==0
square = lambda x: x**2
list(filter(iseven, map(square, range(10))))
#but list comprehensions are preferred in Python
[x for x in [x**2 for x in range(10)] if x%9!=0]
[x**2 for x in range(10) if x%9!=0]


from functools import reduce, partial
reduce(lambda x,y: x*y, map(sqr, range(1,50)))
f2=partial(lambda x,y: x/y,2)
f2(8)

#what if we want to fix the second parameter and we don't want to mess with the function?
f2=partial(lambda x,y: (lambda x,y: x/y)(y,x),2)
f2(8)



#Exercise1
#Write a function that takes a scoretable that is a map from scores to list of names. If the score is in the table it appends the name to the list, otherwise it creates a list containing one name
def process1(scoretable, score, name):
#get, setdefault, defaultdict

#Exercise2
#The same as before but each name should be just once in each list
def process2(scoretable, score, name):
#possible solution is to use set

#Exercise3
#Reverse operation to exercise 2
def process3(scoretable, score, name):

#Excersise 4
#https://holypython.com/intermediate-python-exercises/exercise-16-python-list-comprehensions/
#16-f

#Excersise 5
def words_not_the(sentence):
    """Words not 'the'
    Given a sentence, produce a list of the lengths of each word in the sentence, but only if the word is not 'the'.
        >>> words_not_the('the quick brown fox jumps over the lazy dog')
        [5, 5, 3, 5, 4, 4, 3]
    """
    pass

#Exercise 6
#Given two equally long list return only elements from identical positions
#hint zip
[x[0] for x in zip(a,b) if x[0]==x[1]]

#Exercise 7
#The same but you want to return tuple pairs (index, value)
#hint use range


