import unittest
from unittest.mock import Mock

from src.hraciaplocha import HraciaPlocha, Figurka


class TestHraciaPlocha(unittest.TestCase):
    def setUp(self):
        self.policka = [[None for _ in range(8)] for _ in range(8)]
        self.plocha1 = HraciaPlocha(self.policka, "W")
        self.policka2 = [[None for _ in range(8)] for _ in range(8)]
        self.plocha2 = HraciaPlocha(self.policka, "B")

    def test_pohni_figurkou(self):
        self.assertIsNone(self.plocha1.pohni_figurkou((0,1), (1,1)))
        self.assertIsNone(self.plocha1.pohni_figurkou((2,9), (1,1)))
        self.assertIsNone(self.plocha1.pohni_figurkou((1,1), (1,1)))
        #pridame figurku na 1,1
        tahy = Mock()
        self.policka[0][0] = Figurka("WP", 0, tahy)
        tahy.return_value = [] #ziaden tah
        self.assertIsNone(self.plocha1.pohni_figurkou((1,1), (2,1)))
        tahy.return_value = ((self.plocha2, (2,2)),) #mame iny tah
        self.assertIsNone(self.plocha1.pohni_figurkou((1,1), (2,1)))
        tahy.return_value = ((self.plocha2, (1,0)),) #mame spravny tah
        self.policka[0][0] = Figurka("BP", 0, tahy) #zla farba figurky
        self.assertIsNone(self.plocha1.pohni_figurkou((1,1), (2,1)))
        self.policka[0][0] = Figurka("WP", 0, tahy) #dobra farba figurky
        res = self.plocha1.pohni_figurkou((1,1), (2,1))
        self.assertIs(res, self.plocha2)
        
        

if __name__ == '__main__':
    unittest.main()

