### Unit tests, mocking and unit testing frameworks

I use Python unittest framework. However, I want you to notice, that you really do not need any framework to write unit tests and test doubles. Everything you see in these examples could be easily rewritten without unittest, you just lose the nicely formated test results, mocking and composing tests is slightly harder, but nothing major. You can do reasonable testing without unit testing frameworks.


### Unit tests

Consider the tests for `FIFARankingStrategy.py` (the module is not written very well, but whatever). While writing tests you should keep things as simple as possible (you shouldn't use if/for, you follow scenarios, there is always just one path of execution). You may end up with something like `TestFIFARankingStrategy_version1.py`. The problem with this approach is that it is too time consuming to write and read full tests using this approach. To be honest a fully implemented ranking would be hard to test sufficiently as a single unit - there are just too many things that could happen (see example from 18.3.where we fix this). We can significantly improve the tests by simply following the Don't Repeat Yourself rule. See `TestFIFARankingStrategy.py` - we moved the repeating code into helper functions. Now it is much easier to write tests.

Note that I decided not to use any mocking features of unittest. I just write my own test doubles and it is not that hard.


###Mocking

If you use Sociable tests, you need some mocking. If you use solitary test you need a lot of mocking. There are various approaches to testing but it is mostly about the degree of control you want to have about what happens with the mocked objects. See `TestFIFARanking_solitary.py`.
