#include<vector>
#include<memory>

#include<iostream>

//C++ and OOP
//Object slicing in C++
//https://www.geeksforgeeks.org/object-slicing-in-c/

//It seems weird - but this is to a degree caused by a violation of 
//Liskov substitution principle - subclass cannot be substituted for superclass 
//as it has different memory requirements

//OOP Polymorphism in C++. See Runtime polymorphism.
//https://www.geeksforgeeks.org/polymorphism-in-c/
//You need to go through pointers to do what you want

//BTW it is not as ugly as it looks like .. you can use smart pointers efficiently
//Ad live with this as it is
class A {
protected:
    int x;
public:
    A(int i): x(i) {}
	virtual int i() const {return x;}
};

class B: public A{
	int y;
public:
    B(int i, int j): A(i), y(j) {}
	virtual int i() const {return x+y;}
};

void test1() {
	std::vector<std::unique_ptr<A>> vec;
	vec.emplace_back(std::make_unique<A>(1));
	vec.emplace_back(std::make_unique<B>(3, 4));
	for(const auto &p: vec)
		std::cout<<p->i()<<",";
}


//OK, we are not here to talk about OOP, but about generic programming?
//See compile time polymorphysm:
//https://www.geeksforgeeks.org/polymorphism-in-c/

class C {
	int x;
public:
	C(int i): x(i) {}
	int i() const {return x;}
};

class D {
	int x;
public:
	D(int i): x(i) {}
	int i() const {return x+4;}
};


template<class CorD>
void test2() {
	CorD cd{1};
	std::cout<<cd.i();
}
/*
Implicit interface:
T must have T(int)
T must have .i() and these result must be valid in std::cout<<
*/

//We have template deduction
template<class CorD>
void test3(CorD x) {
	std::cout<<x.i();
}



//Quite pretty and easy to use, isn't it?
//The point is that the compiler generates two versions of test2 and test3.
//And if you create another class that satisfies given interface (x.i() can be sent to cout)
//you can use test3 however you want.

//Note that what we have done is something similar to Strategy pattern 
//strategy injected via a method, although we have a function here it is probably not that hard to imagine.
//We can inject the strategy in constructor.
template<class CorD>
class Test4 {
	CorD x;
public:
	Test4(CorD x_): x(x_) {}
	void do_stuff() {std::cout<<x.i();}
};

class Test4b {
public:
	Test4b() {}
    template<class CorD>
	void do_stuff(CorD x) {std::cout<<x.i();}
};
//Some people call compile-time Strategy pattern as Policy pattern

//Compile-time polymorphism has advantages
//Check example1start.cpp
//In C and in most other programming languages the predicate of std::find_if would use runtime-polymorphism
//Here we use compile-time polymorphism. This allows the compiler to do its job and do stuff like inlining
//the function calls.
//These are cases where C++ can outperform C.
//On the other hand, generic programming approach can create too many types in some instances.

//OOP - encapsulation, inheritance, polymorphism.
//Generic programming offers the same encapsulation
//Inheritance - The use of inheritance beyond inheriting interfaces is questionable,
//              many smart people suggest against using Inheritance as a tool to avoid code duplication.
//              Composition over inheritance. Thus inheritance is mostly for polymorphism.
//              Thus we are quite OK with just having the ability to define interfaces and use polymorphism.

//Check test3
//Is there any interface? 
//It is like in Python - duck typing. There is an implicit interface
//Check example1start.cpp again.
//Does find_if have an interface? Of course it has an implicit one.
//But here is the problem, what if an issue occours deep within something called by something called
//by something called by find_if (this can be especially fun with iterators). 
//It would be nice to find all issues right away. To define the interface

//Generic programming's equivalent for interface is a concept
//You need C++20 for the next examples to work
//Check example1.cpp.

//Check example2.cpp for a slightly more complex use of predicates.
//Check example3.cpp for composite pattern using compile-time polymorphism.

//Show my tableaux library, my strong type logic library, ect...

int main(){
	std::cout<<"\n\nTest 1:\n";
	test1();
	std::cout<<"\n\nTest 2:\n";
	test2<C>();
	test2<D>();
	std::cout<<"\n\nTest 3:\n";
	C c{2};
	D d{5};
	test3(c);
	test3(d);
	std::cout<<"\n\nTest 4:\n";
	Test4(c).do_stuff();
	Test4(d).do_stuff();
}


