#include "tableaux.hpp"
#include "tableaux_correct.h"
#include "mytableaux.hpp"
#include "print_tableaux.hpp"

void test1() {
    Variable x{'x'}, y{'y'}, z{'z'};
    Predicate P{'P'};
    Tableaux input; 
    {
	auto x00 = &input;
	auto x01 = emplace_next (x00, SPlus , 1, true , Nand(P(x), Nand(P(y), P(z))) );
	auto x02 = emplace_next (x01, SPlus , 2, true , Nand(P(z), Nand(Nand(P(x),P(y)), Nand(P(z),P(y)))) ); 
	auto x03 = emplace_next (x02, SPlus , 3, true , Nand(Nand(P(z), P(z)), Nand(P(y), P(z))) );
	auto x04 = emplace_next (x03, SPlus , 4, false, Nand(P(x), P(y)) );
    }
    Tableaux output = my_tableaux();
    assert(is_correct(output) && is_closed(output) && is_subtableaux(input, output));
}


void test_VariableSource() {
    VariableSource vs;
    Predicate P{'P'};
    Predicate Q{'Q'};
    Variable x{'x'};
    Variable y{'y'};
    assert(vs.new_variable() == 1);
    assert(vs.new_variable() == 2);
    assert(vs.get_variable(P(x)) == 3);
    assert(vs.get_variable(P(x)) == 3);
    assert(vs.get_variable(P(x, x)) == 4);
    assert(vs.get_variable(P(x)) == 3);
    assert(vs.new_variable() == 5);
    assert(vs.get_variable(P(y)) == 6);
    assert(vs.get_variable(Q(x)) == 7);
    assert(vs.get_variable(P(y)) == 6);
}



void test_to_cnf() {
    Predicate P{'P'};
    Variable x{'x'};
    //We set vs to start with variables from 21
    VariableSource vs;
    for(int i=0; i<20; i++) vs.new_variable();
    auto res = to_CNF(Nand(P(x), P(x)), vs);
    std::vector<std::vector<int>> correct = {{-21, -21}};
    assert(res == correct);
}

void test_to_cnf2() {
    Predicate P{'P'};
    Variable x{'x'};
    VariableSource vs;
    auto res = to_CNF(Nand(P(x), Nand(P(x), P(x, x))), vs);
    std::vector<std::vector<int>> correct = {{1, -1}, {2, -1}};
    assert(res == correct);
}

void test_to_cnf3() {
    Predicate P{'P'};
    Variable x{'x'};
    VariableSource vs;
    auto res = nandformulatoCNF({Nand(P(x), Nand(P(x), P(x, x))),
                                 Nand(P(x), P(x)) });
    std::vector<std::vector<int>> correct = {{1, -1}, {2, -1}, {-1, -1}};
    assert(res == correct);
}

void test_to_cnf4() {
    Predicate P{'P'};
    Variable x{'x'};
    Variable y{'y'};
    VariableSource vs;
    auto res = nandformulatoCNF({Nand(  Nand(P(x), P(y))  ,  Nand(P(x), P(x, x))  )});
    std::vector<std::vector<int>> correct = {{1, 2}, {3, -1}, {4, -1}, {3, -2}, {5, -2}};
    assert(res == correct);
}

void test_sat() {
    Predicate P{'P'};
    Variable x{'x'};
    Formula f_px = P(x);
    Formula f_not_px = Nand(P(x), P(x));
    Formula f_px2 = Nand(f_not_px, f_not_px);
    Formula f_true = Nand(f_px, f_not_px);
    Formula f_false = Nand(f_true, f_true);
    assert(nandformulaSAT({f_px}));
    assert(nandformulaSAT({f_not_px}));
    assert(nandformulaSAT({f_not_px, f_not_px}));
    assert(nandformulaSAT({f_true}));
    assert(!nandformulaSAT({f_px, f_not_px}));
    assert(!nandformulaSAT({f_false}));
    assert(!nandformulaSAT({f_px2, f_not_px}));
    assert(!nandformulaSAT({f_not_px, f_false}));
}


void test_tableaux_contradiction() {
    Variable x{'x'}, y{'y'}, z{'z'};
    Predicate P{'P'};
    Tableaux input; 
    {
	auto x00 = &input;
	auto x01 = emplace_next (x00, SPlus , 1, true , P(x) );
	           emplace_next (x01, SPlus , 2, false , P(x) );
    }
    assert(extendTableaux(input));
    assert(is_correct(input));
    assert(is_closed(input));
}

void test_tableaux_contradiction2() {
    Variable x{'x'}, y{'y'}, z{'z'};
    Predicate P{'P'};
    Tableaux input; 
    {
	auto x00 = &input;
	auto x01 = emplace_next (x00, SPlus , 1, true , P(x) );
	           emplace_next (x01, SPlus , 2, false , P(y) );
    }
    assert(!extendTableaux(input));
    assert(is_correct(input));
    assert(!is_closed(input));
}

void test_tableaux_alpha() {
    Variable x{'x'}, y{'y'}, z{'z'};
    Predicate P{'P'};
    Tableaux input; 
    {
	auto x00 = &input;
	auto x01 = emplace_next (x00, SPlus , 1, false , Nand(P(x), P(y)) );
	           emplace_next (x01, SPlus , 2, false , P(x) );
    }
    assert(extendTableaux(input));
    assert(is_correct(input));
    assert(is_closed(input));
}


void test_tableaux_beta() {
    Variable x{'x'}, y{'y'}, z{'z'};
    Predicate P{'P'};
    Tableaux input; 
    {
    	auto x00 = &input;
    	auto x01 = emplace_next (x00, SPlus , 1, true , Nand(P(x), P(y)) );
    	auto x02 = emplace_next (x01, SPlus , 2, true , P(x) );
	               emplace_next (x02, SPlus , 3, false , Nand(P(y), P(y)) );
    }
    assert(extendTableaux(input));
    assert(is_correct(input));
    assert(is_closed(input));
}

void test_tableaux_beta2() {
    Predicate P{'P'};
    Formula f = Nand( Nand( P() , Nand(P(),P()) ), 
                      Nand( P() , Nand(P(),P()) ) );
    Tableaux input; 
    {
    	auto x00 = &input;
        emplace_next (x00, SPlus , 1, true , f );
    }
    assert(extendTableaux(input));
    std::cout<<print_tableaux(input);
    assert(is_correct(input));
    assert(is_closed(input));
}



int main() {
    test1();
    test_VariableSource();
    test_to_cnf();
    test_to_cnf2();
    test_to_cnf3();
    test_to_cnf4();
    test_sat();
    test_tableaux_contradiction();
    test_tableaux_contradiction2();
    test_tableaux_alpha();
    test_tableaux_beta();
    test_tableaux_beta2();
}
