#include "dominating.hpp"
#include <iostream>
#include <cstdlib>
#include <cassert>



int main() {
    Graph graph1{ {1, 2, 3, 4}, //0
                  {0}, //1
                  {0}, //2 
                  {0}, //3
                  {0} //4
                };
    Graph graph2{ {1, 2, 3}, //0
                  {0}, //1
                  {0}, //2 
                  {0, 4}, //3
                  {3} //4
                };
    Graph graph3{ {}, //0
                  {}, //1
                  {}, //2 
                  {}, //3
                  {} //4
                };
    Graph graph4{ {1, 4}, //0
                  {0, 2}, //1
                  {1, 3}, //2 
                  {2, 4}, //3
                  {3, 0} //4
                };
    Graph graph5{ {1}, //0
                  {0,2}, //1
                  {1,3}, //2 
                  {2,4}, //3
                  {3,5}, //4
                  {4,6}, //5
                  {5} //6
                };
    VertexTypes types1{10, 10, 10, 10, 10};
    VertexTypes types2{20, 10, 10, 10, 10};
    VertexTypes types3{10, 30, 10, 10, 10};
    VertexTypes types4{ 0,  0,  0,  0,  0};
    VertexTypes types5{20,  0,  0,  0,  0};
    VertexTypes types6{ 0, 30,  0,  0,  0};


/******************************
Test create_relaxed_LP
*******************************/

    auto test = [](auto graph, auto types, REAL expected) {
        LPHelper lp(std::vector<std::string>(5, ""));       
        create_relaxed_LP(lp, graph, types);
        assert(lp.solve() == OPTIMAL);
        REAL res = lp.get_objective();
        assert(std::abs(res-expected) < 0.001);
    };

    test(graph1, types1, 1);
    test(graph1, types2, 4);
    test(graph1, types3, 2);
    test(graph1, types4, 1);
    test(graph1, types5, 4);
    test(graph1, types6, 2);
    test(graph4, types1, 2);
    test(graph4, types2, 2);
    test(graph4, types3, 2);
    test(graph4, types4, 1.66666);
    test(graph4, types5, 2);
    test(graph4, types6, 2);


/******************************
Test min_dominating_set_size_ilp
*******************************/

   assert(min_dominating_set_size_ilp(graph1) == 1);
   assert(min_dominating_set_size_ilp(graph2) == 2);
   assert(min_dominating_set_size_ilp(graph3) == 5);
   assert(min_dominating_set_size_ilp(graph4) == 2);
   assert(min_dominating_set_size_ilp(graph5) == 3);


   //tu by som v pripade potreby odtestoval pomocne funkcie, ale je to jednorazovy projekt
   //a dnes mi zazrakom vsetko funguje. Okrem toho mam dalsie testy, ktorymi kontrolujem 
   //vsetky riesenia), takze vinimocne nepotrebujem napisat test pre 
   //MaxDegreeHeuristic, LastLPHeuristics, is_solution, pick_vertex
   //Ak by som ocakaval, ze sa k tomuto kodu budem vracat, alebo by to bolo do bakalarky,
   //tak tie testy napisem (co ak mam chybu v implementacii heuristiky, to na vysledku nepoznat,
   //a porom by som tvrdil, ze heuristika xy nefunguje...).

/******************************
Test BNB
*******************************/
   assert(min_dominating_set_size_bnb(graph1) == 1);
   assert(min_dominating_set_size_bnb(graph2) == 2);
   assert(min_dominating_set_size_bnb(graph3) == 5);
   assert(min_dominating_set_size_bnb(graph4) == 2);
   assert(min_dominating_set_size_bnb(graph5) == 3);
}
