#Tableaux 0.01

Knižnica na prácu s tablami. Ak objavíme nejakú chybu, updatenemu ju, všímajte si verziu.

####tableaux.hpp

Obsahuje triedy:
- **Term** - Term. Momentálne nepodporuje funkčné symbolu je to vlastne. Je definovaný ako
*using Term = std::variant<Variable, Constant>;*
- **Variable** - Premenna jazyka logiky
- **Constant** - Konštanta jazyka logiky.

- **Formula** - Formula. Momentálne podporuje iba logické spojky AND a NAND, všeobecný kvantifikátor a Predikátové atómy. Nepodporuje logické spojky ako OR, NOT a nepodporuje atóm rovnosti. Definované ako *using Formula = std::variant<Nand, And, Forall, PredicateAtom>;*
- **Nand** - Logická spojka NAND.
- **And** - Logická spojka AND (+ overliad pre operátor **operator&&** medzi dvoma formulami).
- **Forall** - Všeobecný kvantifikátor
- **PredicateAtom** - Predikátový atóm.
- **Predicate** - pomocná trieda na krajšie vytváranie inštancií PredicateAtom.

- **TableauxLine** - Reprezentuje riadok tabla. Definícia *using TableauxLine = std::variant<std::monostate, AlphaLine, BetaLine, GammaLine, DeltaLine, SPlusLine, ContradictionLine>;*
- **AlphaLine**, **BetaLine**, **GammaLine**, **DeltaLine**, **SPlusLine**, **ContradictionLine** - reprezentujú konkrétne typy riadkov v table.
- **emplace_next**, **emplace_next1**, **emplace_next2** - Funkcie na rozšírenie/zmenu tabla. *emplace_next1* a *emplace_next2* sú na rozšírenie *BetaLine*, Pri iných typoch riadkov a na prázdne *Tableaux* sa používa *emplace_next*.
- **NoLine**, **Alpha**, **Beta**, **Gamma**, **Delta**, **SPlus** , **Contra** - Objekty, ktoré sa používajú ako druhý argument v emplace funkciách. Určujú typ nového riadku.
- **Tableaux** - Trieda reprezentujúca tableaux.

- **TableauxIterator**, **TableauxConstIterator** - Iterátory, ktoré uľahčujú prechádzanie tablom.
- **PreviousFormula** - Iterátory si pamätajú vybrané info o predchádzajúcich formulách vo vetve, v ktorej sa nachádzajú. Trieda je definovaná *using PreviousFormula = std::tuple<int, bool, Formula>;*

Pre použitie *tableaux.hpp* je postačujúce ho vložiť na vhodné miesto a includnuť. Ak si chcete pozrieť ako so spomínanymi triedami robiť pozrite si *how_to_work_with_tableaux.cpp*.


####tableau_correct.h, tableau_correct.cpp

Obsahuje funkcie (trieda *Tableaux* sa automaticky konvertuje na iteratory):
- **int traverse_count(TableauxConstIterator ti);** - počet riadkov v table.
- **bool is_subtableaux(TableauxConstIterator ti1, TableauxConstIterator ti2);** - či je prvé tableaux podtablóm druhého.
- **bool is_closed(TableauxConstIterator ti);** - je uzavreté.
- **bool only_splus(TableauxConstIterator ti);** - obsahuje iba S+ riadky
- **bool no_splus(TableauxConstIterator ti);** - neobsahuje S+ riadky
- **bool splus_only_start(TableauxConstIterator ti);** - S+ riadky sú iba na začiatku tabla
- **bool is_correct(TableauxConstIterator ti);** - Overí, či je tableaux korektné, Momentálne implementované iba pre spojku Nand a predikátové atómy (žiadne iné spojky, či kvantifikátory).

Na použitie týchto funkcií potrebujete includnuť *tableau_correct.h* a váš sdroják kompilovať spolu s *tableau_correct.cpp*.

####Kompilácia

Na prácu s knižnicou potrebujete dostatočne moderný kompilátor C++. Je potrebné aby kompilátor podporoval štandard C++20. My to kompilujeme s g++ verzia 10.2.0. Presné príklazy nájdete v *Makefile*.




