#include "tableaux.hpp"

int traverse_count(TableauxConstIterator ti) {
	if (const AlphaLine *x; (x = ti.to_alternative(Alpha))) {
		return traverse_count(ti.next(x)) +1;
	}
	if (const BetaLine *x; (x = ti.to_alternative(Beta))) { 
		return traverse_count(ti.next1(x)) + traverse_count(ti.next2(x)) + 2;
	}
	if (const GammaLine *x; (x = ti.to_alternative(Gamma))) { 		
		return traverse_count(ti.next(x)) +1;
	}
	if (const DeltaLine *x; (x = ti.to_alternative(Delta))) { 		
		return traverse_count(ti.next(x)) +1;
	}
	if (const SPlusLine *x; (x = ti.to_alternative(SPlus))) { 		
		return traverse_count(ti.next(x)) +1;
	}
	if (const ContradictionLine *x; (x = ti.to_alternative(Contra))) { 		
		return 1;
	}
	//Monostate
	return 0;
}


bool is_closed(TableauxConstIterator ti) {
	if (const AlphaLine *x; (x = ti.to_alternative(Alpha))) {
		return is_closed(ti.next(x));
	}
	if (const BetaLine *x; (x = ti.to_alternative(Beta))) { 
		return is_closed(ti.next1(x)) && is_closed(ti.next2(x));
	}
	if (const GammaLine *x; (x = ti.to_alternative(Gamma))) {
		return is_closed(ti.next(x));
	}
	if (const DeltaLine *x; (x = ti.to_alternative(Delta))) {
		return is_closed(ti.next(x));
	}
	if (const SPlusLine *x; (x = ti.to_alternative(SPlus))) {
		return is_closed(ti.next(x));
	}
	if (const ContradictionLine *x; (x = ti.to_alternative(Contra))) {
		return true;
	}
	//Monostate
	return false;
}


bool only_splus(TableauxConstIterator ti) {
	if (const AlphaLine *x; (x = ti.to_alternative(Alpha))) {
		return false;
	}
	if (const BetaLine *x; (x = ti.to_alternative(Beta))) { 
		return false;
	}
	if (const GammaLine *x; (x = ti.to_alternative(Gamma))) {
		return false;
	}
	if (const DeltaLine *x; (x = ti.to_alternative(Delta))) {
		return false;
	}
	if (const SPlusLine *x; (x = ti.to_alternative(SPlus))) {
		return only_splus(ti.next(x));
	}
	if (const ContradictionLine *x; (x = ti.to_alternative(Contra))) {
		return false;
	}
	//Monostate
	return true;
}


bool no_splus(TableauxConstIterator ti) {
	if (const AlphaLine *x; (x = ti.to_alternative(Alpha))) {
		return no_splus(ti.next(x));
	}
	if (const BetaLine *x; (x = ti.to_alternative(Beta))) { 
		return no_splus(ti.next1(x)) && no_splus(ti.next2(x));
	}
	if (const GammaLine *x; (x = ti.to_alternative(Gamma))) {
		return no_splus(ti.next(x));
	}
	if (const DeltaLine *x; (x = ti.to_alternative(Delta))) {
		return no_splus(ti.next(x));
	}
	if (const SPlusLine *x; (x = ti.to_alternative(SPlus))) {
		return false;
	}
	if (const ContradictionLine *x; (x = ti.to_alternative(Contra))) {
		return true;
	}
	//Monostate
	return true;
}

bool splus_only_start(TableauxConstIterator ti) {
	if (const AlphaLine *x; (x = ti.to_alternative(Alpha))) {
		return no_splus(ti.next(x));
	}
	if (const BetaLine *x; (x = ti.to_alternative(Beta))) { 
		return no_splus(ti.next1(x)) && no_splus(ti.next2(x));
	}
	if (const GammaLine *x; (x = ti.to_alternative(Gamma))) {
		return no_splus(ti.next(x));
	}
	if (const DeltaLine *x; (x = ti.to_alternative(Delta))) {
		return no_splus(ti.next(x));
	}
	if (const SPlusLine *x; (x = ti.to_alternative(SPlus))) {
		return splus_only_start(ti.next(x));
	}
	if (const ContradictionLine *x; (x = ti.to_alternative(Contra))) {
		return true;
	}
	//Monostate
	return true;
}


bool is_subtableaux(TableauxConstIterator ti1, TableauxConstIterator ti2) {
 	if (const AlphaLine *x1; (x1 = ti1.to_alternative(Alpha))) {
		if (const AlphaLine *x2; (x2 = ti2.to_alternative(Alpha))) {			
			if (x1 != x2) return false;
		    return is_subtableaux(ti1.next(x1), ti2.next(x2));
		}
		else return false;
	}
 	if (const BetaLine *x1; (x1 = ti1.to_alternative(Beta))) {
		if (const BetaLine *x2; (x2 = ti2.to_alternative(Beta))) {
			if (x1 != x2) return false;
		    return is_subtableaux(ti1.next1(x1), ti2.next1(x2)) && is_subtableaux(ti1.next2(x1), ti2.next2(x2));
		}
		else return false;
	}
 	if (const GammaLine *x1; (x1 = ti1.to_alternative(Gamma))) {
		if (const GammaLine *x2; (x2 = ti2.to_alternative(Gamma))) {
			if (x1 != x2) return false;
		    return is_subtableaux(ti1.next(x1), ti2.next(x2));
		}
		else return false;
	}
 	if (const DeltaLine *x1; (x1 = ti1.to_alternative(Delta))) {
		if (const DeltaLine *x2; (x2 = ti2.to_alternative(Delta))) {
			if (x1 != x2) return false;
		    return is_subtableaux(ti1.next(x1), ti2.next(x2));
		}
		else return false;
	}
 	if (const SPlusLine *x1; (x1 = ti1.to_alternative(SPlus))) {
		if (const SPlusLine *x2; (x2 = ti2.to_alternative(SPlus))) {
			if (*x1 != *x2) return false;
		    return is_subtableaux(ti1.next(x1), ti2.next(x2));
		}
		else return false;
	}
 	if (const ContradictionLine *x1; (x1 = ti1.to_alternative(Contra))) {
		if (const ContradictionLine *x2; (x2 = ti2.to_alternative(Contra))) {
			if (x1 != x2) return false;
			return true;
		}		    
		else return false;
	}
	//Monostate
	return true;
}


bool is_correct(TableauxConstIterator ti) {
	if (const AlphaLine *x; (x = ti.to_alternative(Alpha))) {
		auto p = ti.find_line(x->reason());
		if (!p) return false;
	    [[maybe_unused]] auto [_, t, f] = p.value();
		if (!std::holds_alternative<Nand>(f)) return false; //only nand supported
		if (t) return false; //alpha rule requires false formula for Nand
		Nand n = std::get<Nand>(f); 
		if (!x->is_true()) return false;
		if ((n.left() != x->formula()) && (n.right() != x->formula())) return false;
		return is_correct(ti.next(x));
	}
	if (const BetaLine *x; (x = ti.to_alternative(Beta))) { 
		auto p = ti.find_line(x->reason());
		if (!p) return false;
	    [[maybe_unused]] auto [_, t, f] = p.value();
		if (!std::holds_alternative<Nand>(f)) return false; //only nand supported
		if (!t) return false; //beta rule requires true formula for Nand
		Nand n = std::get<Nand>(f); 
		if (x->is_true1() && x->is_true2()) return false;
		if ((n.left() != x->formula1()) || (n.right() != x->formula2())) return false;
		return is_correct(ti.next1(x)) && is_correct(ti.next2(x));
	}
	if (const GammaLine *x; (x = ti.to_alternative(Gamma))) {
		return false; //Gamma not supported yet
	}
	if (const DeltaLine *x; (x = ti.to_alternative(Delta))) {
		return false; //Delta not supported yer
	}
	if (const SPlusLine *x; (x = ti.to_alternative(SPlus))) {
		return is_correct(ti.next(x));
	}
	if (const ContradictionLine *x; (x = ti.to_alternative(Contra))) {
		auto p1 = ti.find_line(x->reason1());
		auto p2 = ti.find_line(x->reason2());
		if (!p1) return false;
		if (!p2) return false;
	    [[maybe_unused]] auto [_1, t1, f1] = p1.value();
	    [[maybe_unused]] auto [_2, t2, f2] = p2.value();
		if (t1 == t2) return false;
		if (f1 != f2) return false;
		return true;
	}
	//Monostate
	return true;
}