#include <cassert>
#include "tableaux.hpp"
#include "tableaux_correct.h"
#include <set>

int main() {
	Variable a{'a'};
	Variable b{'b'};
	Variable x{'x'};
	Variable c{'c'};
    Predicate P{'P'};	
	
	
    Tableaux tabl1; 
	{
		auto x00 = &tabl1;
	    auto x01 = emplace_next (x00, SPlus ,  1, true , P(a, b)); //for contradiction
	    auto x02 = emplace_next (x01, SPlus ,  2, false, P(a, b)); //for contradiction
	    auto x03 = emplace_next (x02, SPlus ,  3, false, Nand(P(a, a), P(b, b))); //alpha rule
	    auto x04 = emplace_next (x03, SPlus ,  4, true , Nand(P(a, a), P(b, b))); //beta rule
	    auto x05 = emplace_next (x04, SPlus ,  5, true , Forall(x, P(a, x)));     //gamma rule
	    auto x06 = emplace_next (x05, SPlus ,  6, false, Forall(x, P(a, x)));     //delta rule
	    auto x07 = emplace_next (x06, Beta  ,  7, false, P(a, a),  8, false, P(b,b), 4);
	        auto x09 = emplace_next1(x07, Alpha  ,  9, true, P(b, b), 3);
    	               emplace_next (x09, Contra ,  1,  2);
        //x07 beta 2
//    	    auto x10 = emplace_next2(x07, Gamma  , 10, true, P(a, b), 5, x, a);
//    	    auto x11 = emplace_next (x10, Delta  , 11, true, P(a, c), 6, x, c);
			           emplace_next2(x07, Contra ,  1,  2);					  
	}
	assert(traverse_count(tabl1) == 11); 
	assert(is_closed(tabl1));
    assert(!only_splus(tabl1)); 
    assert(!no_splus(tabl1)); 
    assert(splus_only_start(tabl1));
    assert(is_correct(tabl1));


    Tableaux tabl2; 
	{
		auto x00 = &tabl2; //just for homogeneity
	    auto x01 = emplace_next (x00, SPlus ,  1, true , P(a, b)); //for contradiction
	    auto x02 = emplace_next (x01, SPlus ,  2, false, P(a, b)); //for contradiction
	}
	assert(traverse_count(tabl2) == 2); 
	assert(!is_closed(tabl2));
    assert(only_splus(tabl2)); 
    assert(!no_splus(tabl2)); 
    assert(splus_only_start(tabl2));
    assert(is_correct(tabl2));


    Tableaux tabl3; 
	{
		auto x00 = &tabl3; 
	    auto x01 = emplace_next (x00, SPlus ,  1, true , P(a, b)); //for contradiction
	    auto x02 = emplace_next (x01, SPlus ,  2, false, P(a, b)); //for contradiction
  	               emplace_next (x02, Contra ,  1,  2);
	}
	assert(traverse_count(tabl3) == 3);
	assert(is_closed(tabl3));
    assert(!only_splus(tabl3)); 
    assert(!no_splus(tabl3)); 
    assert(splus_only_start(tabl3));
    assert(is_correct(tabl3));
	

    Tableaux tabl4; 
	{
		auto x00 = &tabl4; 
	    auto x01 = emplace_next (x00, SPlus ,  1, true , P(a, b)); //for contradiction
	    auto x02 = emplace_next (x01, SPlus ,  2, false, P(a, b)); //for contradiction
  	               emplace_next (x02, Contra ,  1,  3);
	}
	assert(traverse_count(tabl4) == 3);
	assert(is_closed(tabl4));
    assert(!only_splus(tabl4)); 
    assert(!no_splus(tabl4)); 
    assert(splus_only_start(tabl4));
    assert(!is_correct(tabl4));


    Tableaux tabl5; 
	{
		auto x00 = &tabl5; 
	    auto x01 = emplace_next (x00, SPlus ,  1, true , P(a, b)); //for contradiction
	    auto x02 = emplace_next (x01, SPlus ,  2, false, P(a, b)); //for contradiction
  	               emplace_next (x02, Contra ,  1,  1);
	}
	assert(traverse_count(tabl5) == 3);
	assert(is_closed(tabl5));
    assert(!only_splus(tabl5)); 
    assert(!no_splus(tabl5)); 
    assert(splus_only_start(tabl5));
    assert(!is_correct(tabl5));


    Tableaux tabl6; 
	{
		auto x00 = &tabl6; 
	    auto x01 = emplace_next (x00, SPlus ,  1, true , P(a, b)); //for contradiction
	    auto x02 = emplace_next (x01, SPlus ,  2, false, P(a, a)); //for contradiction
  	               emplace_next (x02, Contra ,  1,  2);
	}
	assert(traverse_count(tabl6) == 3);
	assert(is_closed(tabl6));
    assert(!only_splus(tabl6)); 
    assert(!no_splus(tabl6)); 
    assert(splus_only_start(tabl6));
    assert(!is_correct(tabl6));


    Tableaux tabl7; 
	{
		auto x00 = &tabl7; 
	    auto x01 = emplace_next (x00, SPlus ,  1, true , Nand(P(a, b), P(b,a))); //for contradiction
	    auto x02 = emplace_next (x01, SPlus ,  2, false, Nand(P(a, b), P(b,a))); //for contradiction
  	               emplace_next (x02, Contra ,  1,  2);
	}
	assert(traverse_count(tabl7) == 3);
	assert(is_closed(tabl7));
    assert(!only_splus(tabl7)); 
    assert(!no_splus(tabl7)); 
    assert(splus_only_start(tabl7));
    assert(is_correct(tabl7));


    Tableaux tabl8; 
	{
		auto x00 = &tabl8; 
	    auto x01 = emplace_next (x00, SPlus ,  1, true , Nand(P(a, b), P(b,a))); //for contradiction
	    auto x02 = emplace_next (x01, SPlus ,  2, false, Nand(P(a, b), P(b,b))); //for contradiction
  	               emplace_next (x02, Contra ,  1,  2);
	}
	assert(traverse_count(tabl8) == 3);
	assert(is_closed(tabl8));
    assert(!only_splus(tabl8)); 
    assert(!no_splus(tabl8)); 
    assert(splus_only_start(tabl8));
    assert(!is_correct(tabl8));
	
	
	Tableaux tabl9; 
	{
		auto x00 = &tabl9; 
	    auto x01 = emplace_next (x00, SPlus ,  1, true , Nand(P(a, b), P(b,a))); //for contradiction
	    auto x02 = emplace_next (x01, SPlus ,  2, false, Nand(P(b, a), P(a,b))); //for contradiction
  	               emplace_next (x02, Contra ,  1,  2);
	}
	assert(traverse_count(tabl9) == 3);
	assert(is_closed(tabl9));
    assert(!only_splus(tabl9)); 
    assert(!no_splus(tabl9)); 
    assert(splus_only_start(tabl9));
    assert(!is_correct(tabl9));


	Tableaux tabl10; 
	{
		auto x00 = &tabl10; 
	    auto x01 = emplace_next (x00, SPlus ,  1, false, Nand(P(a, b), P(b,a))); 
	    auto x02 = emplace_next (x01, Alpha ,  2, true , P(b, a), 1); 
	    auto x03 = emplace_next (x02, Alpha ,  3, true , P(a, b), 1);
	}
	assert(traverse_count(tabl10) == 3);
	assert(!is_closed(tabl10));
    assert(!only_splus(tabl10)); 
    assert(!no_splus(tabl10)); 
    assert(splus_only_start(tabl10));
    assert(is_correct(tabl10));


	Tableaux tabl10b; 
	{
		auto x00 = &tabl10b; 
	    auto x01 = emplace_next (x00, SPlus ,  1, false, Nand(P(a, b), P(b,a))); 
	    auto x02 = emplace_next (x01, Alpha ,  2, false , P(b, a), 1);  //false is incorrect
	    auto x03 = emplace_next (x02, Alpha ,  3, true , P(a, b), 1);
	}
	assert(traverse_count(tabl10b) == 3);
    assert(!is_correct(tabl10b));


	Tableaux tabl11; 
	{
		auto x00 = &tabl11; 
	    auto x01 = emplace_next (x00, SPlus ,  1, false, Nand(P(a, b), P(b,a))); 
	    auto x02 = emplace_next (x01, Alpha ,  2, true , P(b, a), 1); 
	    auto x03 = emplace_next (x02, Alpha ,  3, true , P(a, b), 2); //bad reason
	}
	assert(traverse_count(tabl11) == 3);
    assert(!is_correct(tabl11));
	

	Tableaux tabl12; 
	{
		auto x00 = &tabl12; 
	    auto x01 = emplace_next (x00, SPlus ,  1, false, Nand(P(a, b), P(b,a))); 
	    auto x02 = emplace_next (x01, Alpha ,  2, true , P(b, a), 1); 
	    auto x03 = emplace_next (x02, Alpha ,  3, true , P(a, a), 1); //bad formula
	}
	assert(traverse_count(tabl12) == 3);
    assert(!is_correct(tabl12));

	Tableaux tabl13; 
	{
		auto x00 = &tabl13; 
	    auto x01 = emplace_next (x00, Alpha ,  2, true , P(b, a), 1); //bad reason
	    auto x02 = emplace_next (x01, SPlus ,  1, false, Nand(P(a, b), P(b,a))); 
	    auto x03 = emplace_next (x02, Alpha ,  3, true , P(a, b), 1); 
	}
	assert(traverse_count(tabl13) == 3);
	assert(!is_closed(tabl13));
    assert(!only_splus(tabl13)); 
    assert(!no_splus(tabl13)); 
    assert(!splus_only_start(tabl13));
    assert(!is_correct(tabl13));


	Tableaux tabl14; 
	{
		auto x00 = &tabl14; 
	    auto x01 = emplace_next (x00, Alpha ,  2, true , P(b, a), 1); //bad reason
	}
	assert(traverse_count(tabl14) == 1);
	assert(!is_closed(tabl14));
    assert(!only_splus(tabl14)); 
    assert(no_splus(tabl14)); 
    assert(splus_only_start(tabl14));
    assert(!is_correct(tabl14));


	Tableaux tabl15; 
	{
		auto x00 = &tabl15; 
	    auto x01 = emplace_next (x00, Alpha ,  2, true , P(b, a), 1); //bad reason
	    auto x02 = emplace_next (x01, SPlus ,  1, false, Nand(P(a, b), P(b,a))); 
	}
	assert(traverse_count(tabl15) == 2);
	assert(!is_closed(tabl15));
    assert(!only_splus(tabl15)); 
    assert(!no_splus(tabl15)); 
    assert(!splus_only_start(tabl15));
    assert(!is_correct(tabl15));


    Tableaux tabl16; 
	{
		auto x00 = &tabl16;
	    auto x01 = emplace_next (x00, SPlus ,  4, true , Nand(P(a, a), P(b, b))); 
	    auto x02 = emplace_next (x01, Beta  ,  7, false, P(a, a),  8, false, P(b,b), 4);
    	    auto x03 = emplace_next1(x02, SPlus ,  1, true , P(a, b)); 
        //lp4 beta 2
    	    auto x04 = emplace_next2(x02, SPlus ,  1, true , P(a, b)); 
	}
	assert(traverse_count(tabl16) == 5); 
	assert(!is_closed(tabl16));
    assert(!only_splus(tabl16)); 
    assert(!no_splus(tabl16)); 
    assert(!splus_only_start(tabl16));
    assert(is_correct(tabl16));


    Tableaux tabl17; 
	{
		auto x00 = &tabl17;
	    auto x01 = emplace_next (x00, SPlus ,  4, true , Nand(P(a, a), P(b, b))); //beta rule
	    auto x02 = emplace_next (x01, Beta  ,  7, false, P(a, a),  8, false, P(a,b), 4); //bad formula 2
    	    auto x03 = emplace_next1(x02, SPlus ,  1, true , P(a, a)); 
        //lp4 beta 2
    	    auto x04 = emplace_next2(x02, SPlus ,  1, true , P(a, b)); 
	}
	assert(traverse_count(tabl17) == 5); 
    assert(!is_correct(tabl17));


    Tableaux tabl18; 
	{
		auto x00 = &tabl18;
	    auto x01 = emplace_next (x00, SPlus ,  4, true , Nand(P(a, a), P(b, b))); 
	    auto x02 = emplace_next (x01, Beta  ,  7, false, P(a, a),  8, false, P(b,b), 1); //bad reason
    	    auto x03 = emplace_next1(x02, SPlus ,  1, true , P(a, b)); 
        //lp4 beta 2
    	    auto x04 = emplace_next2(x02, SPlus ,  1, true , P(a, b)); 
	}
	assert(traverse_count(tabl18) == 5); 
    assert(!is_correct(tabl18));

	
    Tableaux tabl19; 
	{
		auto x00 = &tabl19;
	    auto x01 = emplace_next (x00, SPlus ,  4, true , Nand(P(a, a), P(b, b))); 
	    auto x02 = emplace_next (x01, Beta  ,  7, false, P(a, b),  8, false, P(b,b), 4); //bad formula 1
    	    auto x03 = emplace_next1(x02, SPlus ,  1, true , P(a, a)); 
        //lp4 beta 2
    	    auto x04 = emplace_next2(x02, SPlus ,  1, true , P(a, b)); 
	}
	assert(traverse_count(tabl19) == 5); 
    assert(!is_correct(tabl19));


    Tableaux tabl20; 
	{
		auto x00 = &tabl20;
	    auto x01 = emplace_next (x00, SPlus ,  4, true , Nand(P(a, a), P(b, b))); 
	    auto x02 = emplace_next (x01, Beta  ,  7, false, P(a, a),  8, false, P(b,b), 4); 
    	    auto x03 = emplace_next1(x02, Contra ,  7, 4); //left branch error
        //lp4 beta 2
	}
	assert(traverse_count(tabl20) == 4); 
    assert(!is_correct(tabl20));


    Tableaux tabl21; 
	{
		auto x00 = &tabl21;
	    auto x01 = emplace_next (x00, SPlus ,  4, true , Nand(P(a, a), P(b, b))); 
	    auto x02 = emplace_next (x01, Beta  ,  7, false, P(a, a),  8, false, P(b,b), 4); 
        //lp4 beta 2
    	    auto x04 = emplace_next2(x02, Contra ,  7, 4); //right branch error
	}
	assert(traverse_count(tabl21) == 4); 
    assert(!is_correct(tabl21));


    Tableaux tabl22; 
	{
		auto x00 = &tabl22;
	    auto x01 = emplace_next (x00, SPlus ,  1, true , P(a,a)); 
	    auto x02 = emplace_next (x01, SPlus ,  4, true , Nand(P(a, a), P(b, b))); 
	    auto x03 = emplace_next (x02, Beta  ,  7, false, P(a, a),  8, false, P(b,b), 4); 
        //lp4 beta 2
    	    auto x04 = emplace_next2(x03, Contra ,  1, 7); //reference to other branch
	}
	assert(traverse_count(tabl22) == 5); 
    assert(!is_correct(tabl22));


    Tableaux tabl23; 
	{
		auto x00 = &tabl23;
	    auto x01 = emplace_next (x00, SPlus ,  1, true , P(b,b)); 
	    auto x02 = emplace_next (x01, SPlus ,  4, true , Nand(P(a, a), P(b, b))); 
	    auto x03 = emplace_next (x02, Beta  ,  7, false, P(a, b),  8, false, P(b,b), 4); 
    	    auto x04 = emplace_next1(x03, Contra ,  1, 8); //reference to other branch
        //lp4 beta 2
	}
	assert(traverse_count(tabl23) == 5); 
    assert(!is_correct(tabl23));

    return 0;
}




