#include <vector>

enum Color { WHITE = 1, BLACK = 2 };

typedef std::vector<std::vector<int>> Graph;
typedef std::vector<Color> Colouring;

typedef std::vector<int> Clause;
typedef std::vector<Clause> Cnf;

// All following functions are to solve the following task.
// We are given a graph that has vertices coloured with two colours.
// We want to decide if there exists a circuit of length exactly k with 
// prescribed colour pattern. Recall that a circuit is an alternating 
// sequence v_0, e_0, v_1, e_1, v_2, ..., v_{n-1}, e_{n-1}, v_0
// such that
// 1. v_i are distinct vertices of the graph
// 2. e_i are edges of the graph such that e_i is incident with v_i and v_{(i+1) mod n}.
// 
// Graph is given as an adjacency list. Vertices are represented as integers
// 0, 1, ..., |V(G)|-1. Two edges are incident if and only if
// graph[i] contains j and graph[j] contains i. You may assume that if
// graph[i] contains j, then also graph[j] contains[i]
// You may also assume that the length of the coloring and the the number 
// of vertices of the graph match.
// 
// If not stated otherwise, the required colouring pattern is that the colours
// of vertices on the circuit alternate.


// 1. This function uses any trivial algorithm to answer the question.
bool alternatingCircuitExistsTrivial(const Graph&, const Colouring&, unsigned int length);

// 2. This function reformulates the problem as a CNF.
Cnf alternatingCircuitExistsToCNF(const Graph&, const Colouring&, unsigned int length);

// 3. Here we require, that the circuit does not contain three consecutive vertices 
// of the same colour. This function reformulates the problem as a CNF.
Cnf circuitWithoutThreeConsecutiveVerticesOfSameColourExistsToCNF(const Graph&, const Colouring&, unsigned int length);

