#include <iostream>
#include <fstream>
#include <random>
#include <vector>
#include <cassert>
#include "coloured_path.h"


typedef struct {
    int seed;
    int vertices;
    int density;
    int length;
    int answer1;
    int answer2;
} Config;


Config getConfig(int task) {
     switch(task) {
     case 1:
     	return {1, 8, 500, 4, 1, 1};
     case 2:
     	return {1, 8, 500, 8, 0, 0};
     case 3:
     	return {1, 8, 500, 5, 0, 1};
     case 4:
     	return {1, 6, 500, 4, 0, 1};
     case 5:
     	return {1, 20, 300, 18, 0, 1};
     case 6:
     	return {1, 20, 400, 18, 1, 1};
     case 7:
     	return {1, 40, 150, 30, 0, 1};
     case 8:
     	return {2, 8, 500, 5, 0, 0};
     case 9:
     	return {2, 40, 80, 34, 0, 0};
     case 10:
     	return {3, 40, 180, 34, 0, 1};
     case 11:
     	return {3, 40, 220, 32, 1, 1};
     };
     assert(false);
}


inline void write(const Cnf &cnf, const char* filename) {
    std::ofstream myfile;
    myfile.open(filename);
    myfile<<"p cnf "<<"100000"<<" "<<cnf.size()<<"\n";
    for(const Clause &c:cnf) {
        for(int literal:c) {
            myfile<<literal<<" ";
        }
#if PUT==1
            myfile<<" 0\n";
#else
            myfile<<"\n";
#endif
    }
    myfile.close();
}


int main() {
    const Config config = getConfig(VAL);

    const unsigned int n = config.vertices;
    const unsigned int p = config.density; //in percentiles
    
    std::mt19937 gen(config.seed); //set seed

    Graph g(n);
    Colouring c(n, WHITE);
    for(int i=0; i<n; i++) {
        bool isBlack = (gen()%2 == 0);
        if (isBlack) {
            c[i] = BLACK; 
        }
    }
    for(int i=0; i<n; i++) {
        for(int j=i+1; j<n; j++) {
            if (gen()%1000<p) {
                g[i].push_back(j);
                g[j].push_back(i);
            }
        }
    }
    
    for(int i=0; i<n; i++) {
        std::cout<<"Vertex:"<<i<<", Color:"<<c[i]<<", Adjacent:";
        for(int e: g[i]) {
            std::cout<<e<<",";
        }
        std::cout<<"\n";
    }
    
    std::cout<<"Searching for path of length "<<config.length<<".\n";
    

#if TASK==1
    bool result = alternatingCircuitExistsTrivial(g, c, config.length);
    std::cout << "Task 1 finished. Result:"<<result<<"\n";
#endif

#if TASK==2
    Cnf res = alternatingCircuitExistsToCNF(g, c, config.length);
    assert(res.size()>0);
    write(res, "lpi01.txt");
#endif

#if TASK==3
    Cnf res = circuitWithoutThreeConsecutiveVerticesOfSameColourExistsToCNF(g, c, config.length);
    assert(res.size()>0);
    write(res, "lpi01.txt");
#endif


    return 0;
}
