#include <iostream>
#include <fstream>
#include <random>
#include <vector>
#include <cassert>
#include <cmath>
#include <set>
#include "tour.h"


typedef struct {
    int seed;
    int vertices;
    int density;
    int density2;
    int distances;
    int goalDistance;
    std::set<int> answer1;
    std::set<int> answer2;
    std::set<int> answer3;
} Config;


Config getConfig(int task) {
    switch(task) {
        case 1:
            return {
                1, 8, 500, 20, 1000, 5000, 
                {0, 4, 7, 6, 0}, 
                {0, 2, 3, 6, 4, 5, 1, 7, 0}, 
                {0, 7, 6, 0}
            };
        case 2:
            return {
                1, 8, 500, 20, 1000, 5070, 
                {0, 4, 7, 6, 0}, 
                {0, 2, 3, 6, 4, 5, 1, 7, 0}, 
                {0, 6, 7, 0}
            };
        case 3:
            return {
                2, 20, 200, 20, 1000, 15000, 
                {0, 13, 4, 16, 0}, 
                {0, 13, 8, 11, 12, 5, 18, 14, 6, 3, 2, 1, 7, 9, 19, 15, 16, 0}, 
                {0, 13, 3, 2, 1, 12, 11, 14, 18, 5, 8, 9, 19, 15, 16, 0}
            };
        case 4:
            return {
                3, 20, 200, 20, 1000, 16000, 
                {0, 14, 4, 9, 5, 19, 0}, 
                {0, 2, 15, 17, 3, 12, 1, 8, 5, 9, 6, 4, 7, 19, 0}, 
                {0, 2, 15, 17, 3, 12, 1, 14, 4, 7, 19, 0}
            };
        case 5:
            return {
                5, 20, 200, 20, 1000, 35000, 
                {0, 5, 0}, 
                {0, 7, 6, 10, 11, 14, 5, 3, 15, 13, 4, 1, 16, 12, 9, 2, 18, 0}, 
                {0, 7, 6, 10, 11, 14, 5, 3, 15, 13, 4, 1, 16, 12, 9, 2, 18, 0}
            };
        case 6:
            return {
                6, 20, 200, 20, 1000, 2000, 
                {0, 1, 13, 3, 10, 0}, 
                {0, 10, 16, 7, 11, 18, 8, 1, 13, 3, 6, 15, 9, 14, 2, 19, 0}, 
                {0, 1, 13, 19, 0}
            };
        case 7:
            return {
                1, 40, 60, 7, 100, 5000, 
                {0, 15, 37, 30, 0}, 
                {0, 15, 21, 6, 31, 9, 17, 3, 29, 20, 19, 1, 38, 11, 7, 23, 5, 28, 34, 12, 33, 39, 32, 2, 35, 27, 22, 24, 13, 8, 16, 37, 30, 0}, 
                {0, 15, 21, 12, 33, 20, 19, 1, 39, 32, 2, 35, 27, 22, 24, 13, 11, 7, 9, 17, 3, 29, 37, 30, 0}
            };
        case 8:
            return {
                2, 20, 500, 20, 100, 800, 
                {0, 8, 1, 14, 18, 0}, 
                {}, 
                {}
            };
        case 9:
            return {
                2, 40, 500, 20, 100, 1500, 
                {0, 25, 14, 32, 0}, 
                {}, 
                {}
            };
    };
    assert(false);
}


int main() {
    const Config config = getConfig(VAL);

    const unsigned int n = config.vertices;
    const unsigned int p = config.density; //in percentiles
    const unsigned int p2 = config.density2; //in percentiles
    const unsigned int lambda = config.distances; //in percentiles
    
    std::mt19937 gen(config.seed); //set seed

    Graph g;
    for(int i=0; i<n; i++) {
        for(int j=i+1; j<n; j++) {
            int random_value = gen()%1000;
            if (random_value < p) {
                double y = (gen()%1000000)/1000001.;
                double distance = -std::log(1-y)*lambda;
                g.emplace_back(i, j, distance);
                std::cout<<i<<","<<j<<":"<<distance<<"\n";
            }
            if (random_value < p2) {
                double y = (gen()%1000000)/1000001.;
                double distance = -std::log(1-y)*lambda;
                g.emplace_back(i, j, distance);
                std::cout<<i<<","<<j<<":"<<distance<<"\n";
            }
        }
    }


#if TASK==1
    std::vector<int> result = proposeShortestCircuit(g, 0);
    std::set expected = config.answer1;
//    assert(expected == std::set<int>() || expected == std::set<int>(result.begin(), result.end()));
#endif

#if TASK==2
    std::vector<int> result = proposeLongestCircuit(g, 0);
    std::set expected = config.answer2;
//    assert(expected == std::set<int>() || expected == std::set<int>(result.begin(), result.end()));
#endif

#if TASK==3
    std::vector<int> result = proposeCircuit(g, 0, config.goalDistance);
    std::set expected = config.answer3;
// TODO something better
//    assert(expected == std::set<int>() || expected == std::set<int>(result.begin(), result.end()));
#endif
    
    for(int v:result) {
        std::cout<<v<<", ";
    }    
    std::cout<<"\n";

    return 0;
}
