#include<vector>

// v1 and v2 are endvertices of the edge, d is the length of the edge.
typedef struct {
    int v1, v2;
    double d;
} Edge;

// Graph is defined as a list of edges. Vertices correspond to integers present in the edges.
// There may be multiple edges between the vertices
typedef std::vector<Edge> Graph;

// A circuit is an alternating sequence of vertices and edges
// v_1, e_1, v_2, e_2, v_3, ...v_{n-1}, e_{n-1}, v_n, where n>=2,  such that
// - edge e_i has vertices v_i and v_{i+1}, for each i from {1, ..., (n-1)}
// - vertices v_1, ..., v_{n-1} are distinct
// - edges e_1, ..., e_{n-1} are distinct
// - vertices v_1 and v_n are the same.
// The length of a circuit is the sum of length of its edges.
// v_i and that v_1=v_n

// The function returns vertices of a circuit that contains vertex and has length as small as possible.
std::vector<int> proposeShortestCircuit(const Graph&, int vertex);

// The function returns vertices of a circuit that contains vertex and has length as big as possible.
std::vector<int> proposeLongestCircuit(const Graph&, int vertex);

// The function returns vertices of a circuit whose length is as close as possible to length.
// As there tenst to be many similar solutions you are likely to run into numerical problems. 
// Thus, it is sufficient to produce approximate solution, with possible error of 0.1 per proposed circuit vertex.
std::vector<int> proposeCircuit(const Graph&, int vertex, double length);
