#include <iostream>
#include <fstream>
#include <utility>
#include <cassert>
#include <algorithm>
#include "cchn.h"



std::pair<Graph, double> getInput(int task) {
    switch(task) {
        case 1:         //Complete graph on 3 vertices
            return {{
                {1, 2}, //0
                {0, 2}, //1
                {0, 1}, //2
            }, 3};
        case 2:          //Complete graph on 4 vertices
            return {{
                {1,2,3},
                {0,2,3},
                {0,1,3},
                {0,1,2},
            }, 4};
        case 3:        //Star graph K_{1,5}
            return {{
                {1,2,3,4,5},
                {0},
                {0},
                {0},
                {0},
                {0},
            }, 2};
        case 4:        //Cycle of length 6
            return {{
                {1,5}, //0
                {0,2}, //1
                {1,3}, //2
                {2,4}, //3
                {3,5}, //4
                {0,4}, //5
            }, 2};
        case 5:          //Bipartite graph K_{3,3}
            return {{
                {3,4,5}, //0
                {3,4,5}, //1
                {3,4,5}, //2
                {0,1,2}, //3
                {0,1,2}, //4
                {0,1,2}, //5
            }, 2};
        case 6:        //Cycle of length 7
            return {{
                {1,6}, //0
                {0,2}, //1
                {1,3}, //2
                {2,4}, //3
                {3,5}, //4
                {4,6}, //5
                {0,5}, //6
            }, 2.3333};
        case 7:        //The Petersen graph
            return {{
                {1,4,5},
                {0,2,6},
                {1,3,7},
                {2,4,8},
                {0,3,9},
                {0,7,8},
                {1,8,9},
                {2,5,9},
                {3,5,6},
                {4,6,7},
            }, 3};
        case 8:               //Line graph of the complete graph K_5
            return {{
                {1,4,5,6,7,9},
                {0,2,5,6,7,8},
                {1,3,6,7,8,9},
                {2,4,5,6,8,9},
                {0,3,5,7,8,9},
                {0,1,3,4,6,8},
                {0,1,2,3,5,9},
                {0,1,2,4,8,9},
                {1,2,3,4,5,7},
                {0,2,3,4,6,7},
            }, 5};
        case 9:         //The Cycle C5 plus the Path P5 joined by an edge
            return {{
                {1,4,5}, //0
                {0,2},   //1
                {1,3},
                {2,4},
                {0,3},
                {0,6},
                {5,7},
                {6,8},
                {7,9},
                {8},
            }, 2.5};
        case 10:          //Second Blanusa snark
            return {{
                {1,3,10},
                {0,2,6},
                {1,4,8},
                {0,4,5},
                {2,3,7},
                {3,6,17},
                {1,5,7},
                {4,6,15},
                {2,9,11},
                {8,10,13},
                {0,9,14},
                {8,12,15},
                {11,13,14},
                {9,12,16},
                {10,12,17},
                {7,11,16},
                {13,15,17},
                {5,14,16},
            }, 3};
        case 11:               //Line graph of the Petersen graph
            return {{
                {1, 4, 5, 9}, //0
                {0, 2, 5, 6}, //1
                {1, 3, 6, 7}, //2
                {2, 4, 7, 8}, //3
                {0, 3, 8, 9}, //4
                {0, 1, 10, 14},
                {1, 2, 12, 13},
                {2, 3, 10, 11},
                {3, 4, 13, 14},
                {0, 4, 11, 12},
                {5, 7, 11, 14}, //10
                {7, 9, 10, 12}, //11
                {6, 9, 11, 13}, //12
                {6, 8, 12, 14}, //13
                {5, 8, 10, 13}, //14
            }, 3.66666666};
        case 12:          //First Blanusa snark
            return {{
                {1,3,12},
                {0,2,6},
                {1,4,8},
                {0,4,5},
                {2,3,7},
                {3,6,17},
                {1,5,7},
                {4,6,9},
                {2,9,10},
                {7,8,15},
                {8,11,13},
                {10,12,16},
                {0,11,14},
                {10,14,15},
                {12,13,17},
                {9,13,16},
                {11,15,17},
                {5,14,16},
            }, 2.8};
        case 13:          //Planar graph on 18 vertices
            return {{
                {1,3},
                {0,2},
                {1,4,7},
                {0,14,17},
                {2,5,8},
                {4,6},
                {5,7},
                {2,6,8},
                {4,7,9,12},
                {8,10,13},
                {9,11},
                {10,12},
                {8,11,13},
                {9,12,14,17},
                {3,13,15},
                {14,16},
                {15,17},
                {3,13,16},
            }, 2.5714};
        case 14:          //The dodecahedron graph
            return {{
                {1,2,3},
                {0,4,8},
                {0,10,11},
                {0,5,9},
                {1,10,14},
                {3,11,12},
                {8,13,14},
                {9,12,13},
                {1,6,9},
                {3,7,8},
                {2,4,15},
                {2,5,16},
                {5,7,17},
                {6,7,18},
                {4,6,19},
                {10,16,19},
                {11,15,17},
                {12,16,18},
                {13,17,19},
                {14,15,18},
            }, 2.85714};
        case 15:                //Line graph of the second Blanusa snark
            return {{
                {1, 7, 9, 25},
                {0, 2, 9, 10},
                {1, 3, 8, 10},
                {2, 4, 8, 12},
                {3, 5, 9, 12},
                {4, 6, 9, 26},
                {5, 7, 8, 26},
                {0, 6, 8, 25},
                {2, 3, 6, 7},
                {0, 1, 4, 5},
                {1, 2, 11, 24},
                {10, 14, 21, 24},
                {3, 4, 13, 24},
                {12, 19, 20, 24},
                {11, 15, 21, 23},
                {14, 16, 23, 25},
                {15, 17, 22, 25},
                {16, 18, 22, 26},
                {17, 19, 23, 26},
                {13, 18, 20, 23},
                {13, 19, 21, 22},
                {11, 14, 20, 22},
                {16, 17, 20, 21},
                {14, 15, 18, 19},
                {10, 11, 12, 13},
                {0, 7, 15, 16},
                {5, 6, 17, 18},
            }, 3.333};
        case 16:               //Line graph of the first Blanusa snark
            return {{
                {1, 7, 9, 25},
                {0, 2, 9, 10},
                {1, 3, 8, 10},
                {2, 4, 8, 12},
                {3, 5, 9, 12},
                {4, 6, 9, 26},
                {5, 7, 8, 26},
                {0, 6, 8, 25},
                {2, 3, 6, 7},
                {0, 1, 4, 5},
                {1, 2, 14, 21},
                {14, 15, 23, 24},
                {3, 4, 19, 20},
                {20, 21, 22, 24},
                {10, 11, 15, 21},
                {11, 14, 16, 25},
                {15, 17, 22, 25},
                {16, 18, 22, 26},
                {17, 19, 23, 26},
                {12, 18, 20, 23},
                {12, 13, 19, 21},
                {10, 13, 14, 20},
                {13, 16, 17, 24},
                {11, 18, 19, 24},
                {11, 13, 22, 23},
                {0, 7, 15, 16},
                {5, 6, 17, 18},
            }, 3.5};
        case 17:             //Planar graph on 31 vertices
            return {{
                {1,2,11}, //0
                {0,3,5}, //pridane 3
                {0,4,5}, //pridane 4
                {1,4},
                {2,3},
                {1,2,6,7}, //5
                {5,8,10}, //pridane 8
                {5,9,10}, //pridane 9
                {6,9},
                {7,8},
                {6,7,30}, //10
                {0,12,13},
                {11,28},
                {11,14,17,30},
                {13,15,18},
                {14,16}, //15
                {15,17},
                {13,16,18},
                {14,17,19,22},
                {18,20,23},
                {19,21},//20
                {20,22},
                {18,21,23},
                {19,22,24,27},
                {23,25,28},
                {24,26},//25
                {25,27},
                {23,26,28},
                {12,24,27,29},
                {28,30},
                {10,13,29},//30 - pridane 10
            }, 2.57143};
        case 18:              //Planar graph on 41 vertices
            return {{
                {1,2},
                {0,2,3,7,9},
                {0,1,3,4},
                {1,2,4,5},
                {2,3,5,6},
                {3,4,6,17},
                {4,5,17},
                {1,8,9,16,18,19},
                {7,9,10,11},
                {1,7,8,11,17},
                {8,11,12,13},
                {8,9,10,13},
                {10,13,14,15},
                {10,11,12,15,17},
                {12,15,16},
                {12,13,14,16},
                {7,14,15,17,23},
                {5,6,9,13,16,23},
                {7,19,20,24,26},
                {7,18,20,21},
                {18,19,21,22},
                {19,20,22,23},
                {20,21,23,34},
                {16,17,21,22,34},
                {18,25,26,33,35,36},
                {24,26,27,28},
                {18,24,25,28,34},
                {25,28,29,30},
                {25,26,27,30},
                {27,30,31,32},
                {27,28,29,32,34},
                {29,32,33},
                {29,30,31,33},
                {24,31,32,34,40},
                {22,23,26,30,33,40},
                {24,36,37},
                {24,35,37,38},
                {35,36,38,39},
                {36,37,39,40},
                {37,38,40},
                {33,34,38,39},
            }, 3.4};
        case 19:          //Series-Parallel graph on 58 vertices
            return {{
                {1,7,11},
                {0,2,3},
                {1,4},
                {1,5},
                {2,5},
                {3,4,6},
                {5,10},
                {0,8},
                {7,9},
                {8,10},
                {6,9,29},
                {0,12,13,14},
                {11,15},
                {11,16},
                {11,18},
                {12,17},
                {13,17},
                {15,16,19},
                {14,22},
                {17,20,21},
                {19,23},
                {19,24},
                {18,24},
                {20,24},
                {21,22,23,25,26},
                {24,27},
                {24,28},
                {25,35},
                {26,35},
                {10,30,31},
                {29,32},
                {29,33},
                {30,34},
                {31,34},
                {32,33,35,36,39},
                {27,28,34},
                {34,37,46,49},
                {36,38,41},
                {37,39,40,48},
                {34,38,42},
                {38,43},
                {37,45},
                {39,44},
                {40,47},
                {42,47},
                {41,49},
                {36,50,53},
                {43,44,48},
                {38,47,49},
                {36,45,48,51},
                {46,57},
                {49,52,53,57},
                {51,54},
                {46,51,55},
                {52,56},
                {53,56},
                {54,55,57},
                {50,51,56},
            }, 2.5};
        case 20:           //Planar graph on 75 vertices
            return {{
                {1,74},
                {0,2,5,12},
                {1,3,6},
                {2,4},
                {3,5},
                {1,4,6},
                {2,5,7,10},
                {6,8,11},
                {7,9},
                {8,10},
                {6,9,11},
                {7,10,15},
                {1,13,16,32},
                {12,31},
                {15,16},
                {11,14,31,42},
                {12,14,17,20},
                {16,18,21},
                {17,19},
                {18,20},
                {16,19,21},
                {17,20,22,25},
                {21,23,26},
                {22,24},
                {23,25},
                {21,24,26},
                {22,25,27,30},
                {26,28,31},
                {27,29},
                {28,30},
                {26,29,31},
                {13,15,27,30},
                {12,33,36,43},
                {32,34,37},
                {33,35},
                {34,36},
                {32,35,37},
                {33,36,38,41},
                {37,39,42},
                {38,40},
                {39,41},
                {37,40,42},
                {15,38,41,46},
                {32,44,47,63},
                {43,62},
                {46,47},
                {42,45,62,73},
                {43,45,48,51},
                {47,49,52},
                {48,50},
                {49,51},
                {47,50,52},
                {48,51,53,56},
                {52,54,57},
                {53,55},
                {54,56},
                {52,55,57},
                {53,56,58,61},
                {57,59,62},
                {58,60},
                {59,61},
                {57,60,62},
                {44,46,58,61},
                {43,64,67},
                {63,65,68},
                {64,66},
                {65,67},
                {63,66,68},
                {64,67,69,72},
                {68,70,73},
                {69,71},
                {70,72},
                {68,71,73},
                {46,69,72,74},
                {0,73},
            }, 2.58621};
        case 21:          //Series-Parallel graph on 58 vertices
            return {{
                {1,7,11},
                {0,2,3},
                {1,4},
                {1,5},
                {2,5},
                {3,4,6},
                {5,10},
                {0,8},
                {7,9},
                {8,10},
                {6,9,29},
                {0,12,13,14},
                {11,15},
                {11,16},
                {11,18},
                {12,17},
                {13,17},
                {15,16,19},
                {14,22},
                {17,20,21},
                {19,23},
                {19,24},
                {18,24},
                {20,24},
                {21,22,23,25,26},
                {24,27},
                {24,28},
                {25,35},
                {26,35},
                {10,30,31},
                {29,32},
                {29,33},
                {30,34},
                {31,34},
                {32,33,35,36,39,57},
                {27,28,34},
                {34,37,46,49},
                {36,38,41},
                {37,39,40,48},
                {34,38,42},
                {38,43},
                {37,45},
                {39,44,51},
                {40,47},
                {42,47},
                {41,49},
                {36,50,53},
                {43,44,48},
                {38,47,49},
                {36,45,48,51},
                {46,57},
                {42,49,52,53,57},
                {51,54},
                {46,51,55},
                {52,56},
                {53,56},
                {54,55,57},
                {34,50,51,56},
            }, 2.75};
    };
    assert(false);
}


int main() {
    const auto [graph, expected] = getInput(VAL);
    
    //test assumptions
    for(int i=0; i<graph.size(); i++) {
        for(int j=0; j<graph[i].size();j++) {
            int v=graph[i][j];
            assert(v >= 0);
            assert(v != i);
            assert(v < graph.size());
            if (j != 0) assert(graph[i][j-1]<v);
            assert(std::find(graph[v].begin(),graph[v].end(),i) != graph[v].end());
        }
    }

#if TASK==1
    double result = cchnILP(graph);
    assert(std::abs(expected-result) < 0.001);
#endif

#if TASK==2
    double result = cchnBnB(graph);
    assert(std::abs(expected-result) < 0.001);
#endif
    
    return 0;
}
