#include<vector>

// Graph is given as an incidence list.
// You can assume that graph g satisfies
// For all i from 0...g.size()-1 
//    g[i][j] != i for all j in 0...(g[i].size()-1)
//    g[i][j1] < g[i][j2] for j1<j2, j1,j2 in 0...(g[i].size()-1)
//    g[i] contains j if and only if g[j] contains i for all j from 0..g.size()-1
typedef std::vector<std::vector<int>> Graph;

// We color the vertices with residuals modulo r (denoted as R/rZ), where r is a real number.
// We can represent the residuals using real numbers from [0, r).
// A circular r-coloring is a coloring of vertices that uses colors from R/rZ such that
// the colors c_1 and c_2 on neighboring vertices differs at least by 1. that is   
// 1 <= |c_1 - c_2| <= r-1

// This functions returns the smallest r such that a circular r-coloring exists on G
// Function cchnILP uses ILP to solve the problem. 
double cchnILP(const Graph& g);

// Function cchnBnB uses branch and bound to solve the problem. 
// To make your solution easy to understand separate the branch function and 
// the bound function and make a small comment so I see which is which
double cchnBnB(const Graph& g);


