#include <vector>

// Graph is given as adjacency list. Given Graph g, the graph has graph.size() vertices labeled 0...n-1.
// You may assume that Graph g satisfies:
// vectors g[i] are ordered and have values between 0 and graph.size()-1
// g[i] contains j if and only if g[j] contains i - i.e. the graph is undirected 
// Elements of g[i] are unique (no repetitions) - i.e. the graph has no multiple edges
// g[i] does not contain i - i.e. the graph has no loops
typedef std::vector<std::vector<int>> Graph;

typedef std::vector<int> Clause;
typedef std::vector<Clause> Cnf;

// All following functions are to solve the following task.
// We are given a cubic graph (each vertex is incident with three edges) on n vertices.
// We want to decide if there exists a dominating vertex set of size k.
// A vertex set S \subset V(G) is dominating if each vertex of G is either in S or it
// has a neighbour in S.


// 1. This function uses any trivial algorithm to answer the question.
bool hasDominatingSetOfSizeK(const Graph&, int k);

// 2. This function reformulates the problem as a CNF.
Cnf hasDominatingSetOfSizeKToCNF(const Graph&, int k);

// 3. This function reformulates the problem as a CNF for k=n/4.
Cnf hasDominatingSetOfSizeNOver4ToCNF(const Graph&);

