#include "dominating_set.h"

bool hasDominatingSetOfSizeK(const Graph&, int k) {
    // Anything correct was ok.
    return false;
}

Cnf hasDominatingSetOfSizeKToCNF(const Graph& g, int k) {
    // Instead of doinating sets we sill do dominating k-tuples (thus ordered).
    // Variable representing vertex i is j-th element of the k-tuple.
    auto var = [&] (int i, int j) {return i*k+j+1;};
    Cnf c;    
    
    // Each vertex is dominated
    for(int i=0; i<g.size(); i++) {
        int n1 = g[i][0];
        int n2 = g[i][1];
        int n3 = g[i][2];
        Clause x;
        for(int j=0; j<k; j++) {
            x.push_back(var(i, j));
            x.push_back(var(n1, j));
            x.push_back(var(n2, j));
            x.push_back(var(n3, j));
        }        
        c.push_back(x);
    }
    
    // For each j one vertex is in the k-tuple
    for(int j=0; j<k; j++) {
        for(int i=0; i<g.size(); i++) {
            for(int i2=i+1; i2<g.size(); i2++) {
                c.push_back(Clause({-var(i, j), -var(i2, j)}));
            }    
        }
    }
    
    // The k-tuple is ordered.
    for(int i=0; i<g.size(); i++) {
        for(int i2=i+1; i2<g.size(); i2++) {
            for(int j=0; j<k; j++) {
                for(int j2=j+1; j2<k; j2++) {
                    c.push_back(Clause({-var(i, j2), -var(i2, j)}));
                }
            }
        }
    }
    
    return c;
}

Cnf hasDominatingSetOfSizeNOver4ToCNF(const Graph& g) {
    //Variable repsesent if a vertex is in the dominating set
    auto var = [] (int i) {return i+1;};
    Cnf c;    
    
    // Each vertex is dominated exactly once (thich is equivalent to n/4 vertices in dominating set in cubic graphs)
    for(int i=0; i<g.size(); i++) {
        int n1 = g[i][0];
        int n2 = g[i][1];
        int n3 = g[i][2];
        c.push_back(Clause({var(i), var(n1), var(n2), var(n3)}));
        c.push_back(Clause({-var(i), -var(n1)}));
        c.push_back(Clause({-var(i), -var(n2)}));
        c.push_back(Clause({-var(i), -var(n3)}));
        c.push_back(Clause({-var(n1), -var(n2)}));
        c.push_back(Clause({-var(n1), -var(n3)}));
        c.push_back(Clause({-var(n2), -var(n3)}));
    }
    
    return c;
}

