<?php
//class for box in page with some specified content
//comment
class box {
	public $page;
	private $module;
	private $tableRow;
	protected $vars = array();
	private $attachBoxId = true; //if boxID has be included in hidden div before the box.
	
    function __construct($page,$tblBox) {
    	$this->page = $page;
    	$this->module = in_array($tblBox->get('id'),$page->get('solid_boxes'))?"home":$page->get('module');
    	$this->tableRow = $tblBox;
    }
    
    public function getPath(){
    	$path = "modules/".$this->module;
    	if(!is_dir($path))
    		return false;
    	return $path;
    }
    
    public function getClass(){
    	$file = $this->getPath()."/".$this->tableRow->get("name").".class.php";
    	if(!file_exists($file))
    		return false;
    	return $file;    	
    }
    
    public function display(){
    	$smarty = new Smarty();
    	$smarty->template_dir = $this->getPath()."/templates";
    	foreach($this->vars as $name=>$value)
    		$smarty->assign($name,$value);
    	if($this->attachBoxId)	
			echo "<div style='display:none' id='boxID_".$this->tableRow->get("position")."'>".$this->tableRow->get("id")."</div>";
		return $smarty->display($this->tableRow->get("name").".tpl");	
    }
    
    public function add($name,$value){
    	$this->vars[$name] = $value;
    }
    
}
?>