<?php
class labelsTable extends pgTable{
  protected $table_name = "labels";
  
  /**
   * Funkcia vrati tie menovky, ktore su hlavnymi kategoriami
   */
  public function getRootCategories(){
  	return $this->getMyRows("parent_id=0");
  }
  
  /**
   * Funkcia vrati synovske tagy tagu daneho podla jeho ID
   */
  public function getMySons($id){
  	return $this->getMyRows("parent_id=$id",'name');
  }
  
   /**
    * Funkcia vrati strom tagov ako asociativne pole
    */   
   public function getTagsTree($start_id = 0,$exceptions=array()){
 	 $tags = $this->getMySons($start_id);
   	 if(!$tags)
   	 	return null;
   	 $out = array();	
   	 foreach($tags as $tag){
   	 	if(in_array($tag->get('id'),$exceptions))
   	 		continue;
   	 	$out[] = array("tag"=>$tag,"sons"=>$this->getTagsTree($tag->get('id'),$exceptions));
   	 }
   	 return $out;	
   }

  /**
   * Zobrazi combo ale s polozkami v stromovej strukture
   */
  public function getTagTreeCombo($tree=null){
	if($tree==null)
		$tree = $this->getTagsTree();
	return "\n<select name='tags' id='tagsCombo'>\n<option value='0'></option>\n".$this->getOptionsList(0,$tree,0)."</select>";
  }
	
  public function getOptionsList($tag_id,$sons,$deep){
	if(!$sons)
		return "";
	$html = "";	
	foreach($sons as $son){
		$id = $son['tag']->get('id');
		$html .= "\t<option value='{$id}'>".str_repeat("&nbsp;",$deep).$son['tag']->get('name')."</option>\n".$this->getOptionsList($id,$son['sons'],$deep+4); 
	}	
	return $html;
  }
   
   
   /**
    * Funkcia zmaze seba ale aj svojich potomkov a vsetky vyskyty tagov v ulohach
    */
   public function delete(){
     //mazanie vyskytov v ulohach
     $taskLabels = new tasksLabelsTable;
     $using = $taskLabels->getMyRows("label_id=".$this->get('id'));
     $error_key = -1;
     foreach($using as $key=>$us){
     	if(!$us->delete()){
     		$error_key = $key;
     		break;
     	}
     }
     //ak nam to spadlo na niektorom riadku, tak spravime rollback a vratime chybu
     if($error_key>-1){
     	for($i=0;$i<$error_key;$i++)
     		$using[$i]->add();
     	return false;	
     }
     
     //rekurzivne zmazeme vsetkych synov
     $sons = $this->getMyRows("parent_id=".$this->get('id'));
     $sons_using = array();
     foreach($sons as $key=>$son){
     	$sons_using[$key] = $son->delete();
     	if($sons_using[$key] === false){
     		$error_key = $key;
     		break; 
     	}
     }
     
     //ak nam to spadlo na niektorom riadku, tak spravime rollback a vratime chybu
     if($error_key>-1){
     	for($i=0;$i<$error_key;$i++){
     		$sons[$i]->add();
     		foreach($sons_using[i] as $using){ //rollbackujeme aj pouzitia
     			$using->add();
     		}	
     	}
     	return false;	
     }
     //ak sa zmazem, vratim svoje pouzitia kvoli pripadu, ze by sa nepodarilo zmazat svojho brata a mohli sme obnovit pouzitia tagu
     if(parent::delete())
     	return $using;
     else
     	return false;		
   }
} 
?>