--
-- PostgreSQL database dump
--

SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

--
-- Name: lamsfet; Type: DATABASE; Schema: -; Owner: postgres
--

CREATE DATABASE lamsfet WITH TEMPLATE = template0 ENCODING = 'UTF8';


ALTER DATABASE lamsfet OWNER TO postgres;

\connect lamsfet

SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

--
-- Name: plpgsql; Type: PROCEDURAL LANGUAGE; Schema: -; Owner: postgres
--

CREATE PROCEDURAL LANGUAGE plpgsql;


ALTER PROCEDURAL LANGUAGE plpgsql OWNER TO postgres;

SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = true;

--
-- Name: authorization; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE "authorization" (
    id integer NOT NULL,
    user_id integer NOT NULL,
    login character varying(255) NOT NULL,
    password character varying(32) NOT NULL,
    count integer NOT NULL,
    last_access timestamp without time zone NOT NULL
);


ALTER TABLE public."authorization" OWNER TO postgres;

--
-- Name: authorization_groups; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE authorization_groups (
    id integer NOT NULL,
    name character varying(255) NOT NULL
);


ALTER TABLE public.authorization_groups OWNER TO postgres;

--
-- Name: boxes; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE boxes (
    id integer NOT NULL,
    page_id integer NOT NULL,
    name character varying(255) NOT NULL,
    description text,
    "position" character varying(255)
);


ALTER TABLE public.boxes OWNER TO postgres;

--
-- Name: categories; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE categories (
    id integer NOT NULL,
    name character varying(255) NOT NULL,
    parent_id integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.categories OWNER TO postgres;

--
-- Name: courses; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE courses (
    id integer NOT NULL,
    name character varying(255) NOT NULL
);


ALTER TABLE public.courses OWNER TO postgres;

--
-- Name: courses_terms; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE courses_terms (
    id integer NOT NULL,
    course_id integer NOT NULL,
    year character varying(10) NOT NULL,
    term character(1) NOT NULL
);


ALTER TABLE public.courses_terms OWNER TO postgres;

--
-- Name: dictionary; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE dictionary (
    id integer NOT NULL,
    original text NOT NULL,
    translated text NOT NULL
);


ALTER TABLE public.dictionary OWNER TO postgres;

--
-- Name: labels; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE labels (
    id integer NOT NULL,
    name character varying(255) NOT NULL,
    parent_id integer NOT NULL
);


ALTER TABLE public.labels OWNER TO postgres;

--
-- Name: pages; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE pages (
    id integer NOT NULL,
    name character varying(255) NOT NULL,
    description text,
    template character varying(255) NOT NULL,
    module character varying(255) NOT NULL,
    is_public boolean DEFAULT false NOT NULL
);


ALTER TABLE public.pages OWNER TO postgres;

--
-- Name: pages_access; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE pages_access (
    id integer NOT NULL,
    page_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.pages_access OWNER TO postgres;

--
-- Name: pages_attached_files; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE pages_attached_files (
    id integer NOT NULL,
    file_name character varying(512) NOT NULL,
    file_type character varying(255) NOT NULL,
    page_id integer NOT NULL
);


ALTER TABLE public.pages_attached_files OWNER TO postgres;

--
-- Name: sets; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE sets (
    id integer NOT NULL,
    name character varying(255) NOT NULL,
    date_from timestamp without time zone NOT NULL,
    date_to timestamp without time zone NOT NULL,
    course_term_id integer NOT NULL
);


ALTER TABLE public.sets OWNER TO postgres;

--
-- Name: settings; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE settings (
    id integer NOT NULL,
    property character varying(255) NOT NULL,
    value text NOT NULL,
    user_id integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.settings OWNER TO postgres;

--
-- Name: solutions; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE solutions (
    id integer NOT NULL,
    task_id integer NOT NULL,
    solution text NOT NULL,
    note text
);


ALTER TABLE public.solutions OWNER TO postgres;

--
-- Name: TABLE solutions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE solutions IS 'tabulka spravnych rieseni k uloham (riesenia zadane administratorom)';


--
-- Name: tasks; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tasks (
    id integer NOT NULL,
    name character varying(255) NOT NULL,
    text text NOT NULL,
    active boolean DEFAULT true NOT NULL
);


ALTER TABLE public.tasks OWNER TO postgres;

--
-- Name: tasks_labels; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tasks_labels (
    id integer NOT NULL,
    task_id integer NOT NULL,
    label_id integer NOT NULL
);


ALTER TABLE public.tasks_labels OWNER TO postgres;

--
-- Name: users; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE users (
    id integer NOT NULL,
    name character varying(255) NOT NULL,
    surname character varying(255) NOT NULL,
    email character varying(255) NOT NULL
);


ALTER TABLE public.users OWNER TO postgres;

--
-- Name: users_in_groups; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE users_in_groups (
    id integer NOT NULL,
    authorization_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.users_in_groups OWNER TO postgres;

--
-- Name: has_label(integer, integer, text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION has_label(integer, integer, text) RETURNS boolean
    AS $_$
DECLARE
    p_task ALIAS FOR $1;
    p_label ALIAS FOR $2;
    p_mode ALIAS FOR $3;
BEGIN
	IF p_mode = 'only' THEN
	PERFORM * FROM tasks_labels WHERE task_id=p_task AND label_id=p_label;
	END IF;
	IF p_mode = 'children' THEN
	PERFORM * FROM tasks_labels WHERE task_id=p_task AND (label_id=p_label OR is_label_descendant(label_id,p_label));
	END IF;

	IF NOT FOUND THEN
		RETURN FALSE;
	ELSE
		RETURN TRUE;
	END IF;
	
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.has_label(integer, integer, text) OWNER TO postgres;

--
-- Name: is_label_descendant(integer, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION is_label_descendant(integer, integer) RETURNS boolean
    AS $_$
DECLARE
    p_son ALIAS FOR $1;
    p_label ALIAS FOR $2;
    label RECORD;
BEGIN
	FOR label IN SELECT * FROM labels WHERE parent_id=p_label LOOP 
		IF label.id = p_son THEN
		  RETURN TRUE;
		ELSE
		  IF is_label_descendant(p_son,label.id) THEN
		    RETURN TRUE;
		  END IF;  
		END IF;  
	END LOOP;
	RETURN FALSE;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.is_label_descendant(integer, integer) OWNER TO postgres;

--
-- Name: authorization_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE authorization_groups_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.authorization_groups_id_seq OWNER TO postgres;

--
-- Name: authorization_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE authorization_groups_id_seq OWNED BY authorization_groups.id;


--
-- Name: authorization_groups_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('authorization_groups_id_seq', 2, true);


--
-- Name: authorization_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE authorization_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.authorization_id_seq OWNER TO postgres;

--
-- Name: authorization_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE authorization_id_seq OWNED BY "authorization".id;


--
-- Name: authorization_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('authorization_id_seq', 2, true);


--
-- Name: boxes_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE boxes_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.boxes_id_seq OWNER TO postgres;

--
-- Name: boxes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE boxes_id_seq OWNED BY boxes.id;


--
-- Name: boxes_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('boxes_id_seq', 22, true);


--
-- Name: categories_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE categories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.categories_id_seq OWNER TO postgres;

--
-- Name: categories_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE categories_id_seq OWNED BY categories.id;


--
-- Name: categories_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('categories_id_seq', 1, false);


--
-- Name: courses_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE courses_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.courses_id_seq OWNER TO postgres;

--
-- Name: courses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE courses_id_seq OWNED BY courses.id;


--
-- Name: courses_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('courses_id_seq', 2, true);


--
-- Name: courses_terms_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE courses_terms_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.courses_terms_id_seq OWNER TO postgres;

--
-- Name: courses_terms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE courses_terms_id_seq OWNED BY courses_terms.id;


--
-- Name: courses_terms_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('courses_terms_id_seq', 2, true);


--
-- Name: dictionary_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE dictionary_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.dictionary_id_seq OWNER TO postgres;

--
-- Name: dictionary_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE dictionary_id_seq OWNED BY dictionary.id;


--
-- Name: dictionary_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('dictionary_id_seq', 3, true);


--
-- Name: labels_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE labels_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.labels_id_seq OWNER TO postgres;

--
-- Name: labels_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE labels_id_seq OWNED BY labels.id;


--
-- Name: labels_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('labels_id_seq', 105, true);


--
-- Name: pages_access_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE pages_access_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.pages_access_id_seq OWNER TO postgres;

--
-- Name: pages_access_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE pages_access_id_seq OWNED BY pages_access.id;


--
-- Name: pages_access_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('pages_access_id_seq', 9, true);


--
-- Name: pages_attached_files_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE pages_attached_files_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.pages_attached_files_id_seq OWNER TO postgres;

--
-- Name: pages_attached_files_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE pages_attached_files_id_seq OWNED BY pages_attached_files.id;


--
-- Name: pages_attached_files_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('pages_attached_files_id_seq', 13, true);


--
-- Name: pages_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE pages_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.pages_id_seq OWNER TO postgres;

--
-- Name: pages_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE pages_id_seq OWNED BY pages.id;


--
-- Name: pages_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('pages_id_seq', 11, true);


--
-- Name: sets_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE sets_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.sets_id_seq OWNER TO postgres;

--
-- Name: sets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE sets_id_seq OWNED BY sets.id;


--
-- Name: sets_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('sets_id_seq', 1, false);


--
-- Name: settings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE settings_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.settings_id_seq OWNER TO postgres;

--
-- Name: settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE settings_id_seq OWNED BY settings.id;


--
-- Name: settings_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('settings_id_seq', 3, true);


--
-- Name: solutions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE solutions_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.solutions_id_seq OWNER TO postgres;

--
-- Name: solutions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE solutions_id_seq OWNED BY solutions.id;


--
-- Name: solutions_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('solutions_id_seq', 21, true);


--
-- Name: tasks_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE tasks_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.tasks_id_seq OWNER TO postgres;

--
-- Name: tasks_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE tasks_id_seq OWNED BY tasks.id;


--
-- Name: tasks_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('tasks_id_seq', 13, true);


--
-- Name: tasks_labels_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE tasks_labels_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.tasks_labels_id_seq OWNER TO postgres;

--
-- Name: tasks_labels_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE tasks_labels_id_seq OWNED BY tasks_labels.id;


--
-- Name: tasks_labels_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('tasks_labels_id_seq', 30, true);


--
-- Name: users_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE users_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.users_id_seq OWNER TO postgres;

--
-- Name: users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE users_id_seq OWNED BY users.id;


--
-- Name: users_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('users_id_seq', 2, true);


--
-- Name: users_in_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE users_in_groups_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.users_in_groups_id_seq OWNER TO postgres;

--
-- Name: users_in_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE users_in_groups_id_seq OWNED BY users_in_groups.id;


--
-- Name: users_in_groups_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('users_in_groups_id_seq', 3, true);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE "authorization" ALTER COLUMN id SET DEFAULT nextval('authorization_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE authorization_groups ALTER COLUMN id SET DEFAULT nextval('authorization_groups_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE boxes ALTER COLUMN id SET DEFAULT nextval('boxes_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE categories ALTER COLUMN id SET DEFAULT nextval('categories_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE courses ALTER COLUMN id SET DEFAULT nextval('courses_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE courses_terms ALTER COLUMN id SET DEFAULT nextval('courses_terms_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE dictionary ALTER COLUMN id SET DEFAULT nextval('dictionary_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE labels ALTER COLUMN id SET DEFAULT nextval('labels_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE pages ALTER COLUMN id SET DEFAULT nextval('pages_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE pages_access ALTER COLUMN id SET DEFAULT nextval('pages_access_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE pages_attached_files ALTER COLUMN id SET DEFAULT nextval('pages_attached_files_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE sets ALTER COLUMN id SET DEFAULT nextval('sets_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE settings ALTER COLUMN id SET DEFAULT nextval('settings_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE solutions ALTER COLUMN id SET DEFAULT nextval('solutions_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE tasks ALTER COLUMN id SET DEFAULT nextval('tasks_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE tasks_labels ALTER COLUMN id SET DEFAULT nextval('tasks_labels_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE users ALTER COLUMN id SET DEFAULT nextval('users_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE users_in_groups ALTER COLUMN id SET DEFAULT nextval('users_in_groups_id_seq'::regclass);


--
-- Data for Name: authorization; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO "authorization" VALUES (2, 2, 'student@matfyz.sk', '0cc175b9c0f1b6a831c399e269772661', 2, '2009-03-19 01:40:52');
INSERT INTO "authorization" VALUES (1, 1, 'admin', '0cc175b9c0f1b6a831c399e269772661', 18, '2009-04-22 14:58:02');


--
-- Data for Name: authorization_groups; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO authorization_groups VALUES (1, 'administrator');
INSERT INTO authorization_groups VALUES (2, 'student');


--
-- Data for Name: boxes; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO boxes VALUES (8, 1, 'home', 'uvodny box', 'main');
INSERT INTO boxes VALUES (9, 2, 'login', 'prihlasovaci box', 'main');
INSERT INTO boxes VALUES (10, 1, 'menu', 'navigacia - solid box', 'navigation');
INSERT INTO boxes VALUES (11, 4, 'taskList', 'zoznam uloh', 'main');
INSERT INTO boxes VALUES (12, 3, 'logout', 'odhlasenie zo systemu', 'main');
INSERT INTO boxes VALUES (14, 6, 'taskImport', 'importovy formular ulohy', 'main');
INSERT INTO boxes VALUES (15, 1, 'tableActions', 'manipulacia s DB, pouziva sa v AJAXE', 'ajax');
INSERT INTO boxes VALUES (13, 5, 'taskEdit', 'editacny formular ulohy', 'tab1');
INSERT INTO boxes VALUES (18, 7, 'taskEdit', 'editacny formular pre pridavanie novej ulohy', 'tab1');
INSERT INTO boxes VALUES (19, 5, 'taskTags', 'tagy priradene k ulohe', 'tab2');
INSERT INTO boxes VALUES (17, 5, 'solutions', 'editacia riesenii k ulohe', 'tab3');
INSERT INTO boxes VALUES (20, 10, 'tagHierarchy', 'editacia tagov a hierarchii tagov', 'main');
INSERT INTO boxes VALUES (22, 11, 'adminCourses', 'administracia predmetov', 'main');


--
-- Data for Name: categories; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: courses; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO courses VALUES (1, 'Programovanie v Jave');
INSERT INTO courses VALUES (2, 'Programovacie paradigmy');


--
-- Data for Name: courses_terms; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO courses_terms VALUES (1, 1, '2008/2009', 'L');
INSERT INTO courses_terms VALUES (2, 2, '2008/2009', 'L');


--
-- Data for Name: dictionary; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO dictionary VALUES (1, 'taskEdit', 'zadanie úlohy');
INSERT INTO dictionary VALUES (2, 'solutions', 'riešenia');
INSERT INTO dictionary VALUES (3, 'taskTags', 'tagy');


--
-- Data for Name: labels; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO labels VALUES (1, 'programovacia paradigma', 0);
INSERT INTO labels VALUES (4, 'použité algoritmy', 0);
INSERT INTO labels VALUES (3, 'programovací jazyk', 0);
INSERT INTO labels VALUES (31, 'logické programovanie', 1);
INSERT INTO labels VALUES (35, 'funkcionálne programovanie', 1);
INSERT INTO labels VALUES (36, 'procedurálne programovanie', 1);
INSERT INTO labels VALUES (37, 'objektovo-orientované programovanie', 1);
INSERT INTO labels VALUES (11, 'obtiažnosť', 0);
INSERT INTO labels VALUES (5, 'použité dátové štruktúry', 0);
INSERT INTO labels VALUES (18, 'pole', 5);
INSERT INTO labels VALUES (79, 'dynamické pole', 18);
INSERT INTO labels VALUES (80, 'matica', 18);
INSERT INTO labels VALUES (81, 'zoznam', 5);
INSERT INTO labels VALUES (82, 'graf', 5);
INSERT INTO labels VALUES (83, 'strom', 5);
INSERT INTO labels VALUES (84, 'spájaný zoznam', 81);
INSERT INTO labels VALUES (85, 'rad', 81);
INSERT INTO labels VALUES (86, 'zásobník', 81);
INSERT INTO labels VALUES (87, 'prioritný rad', 85);
INSERT INTO labels VALUES (88, 'halda', 83);
INSERT INTO labels VALUES (89, 'binárný strom', 83);
INSERT INTO labels VALUES (90, 'vyhľadávací strom', 83);
INSERT INTO labels VALUES (91, 'Pascal', 3);
INSERT INTO labels VALUES (92, 'C', 3);
INSERT INTO labels VALUES (93, 'C++', 3);
INSERT INTO labels VALUES (94, 'Haskell', 3);
INSERT INTO labels VALUES (95, 'Java', 3);
INSERT INTO labels VALUES (96, 'Prolog', 3);
INSERT INTO labels VALUES (97, 'SmallTalk', 3);
INSERT INTO labels VALUES (9, 'rekurzia', 4);
INSERT INTO labels VALUES (98, 'backtracking', 4);
INSERT INTO labels VALUES (99, 'triedenie', 4);
INSERT INTO labels VALUES (100, 'vyhladavanie', 4);
INSERT INTO labels VALUES (101, 'quicksort', 99);
INSERT INTO labels VALUES (102, 'bubblesort', 99);
INSERT INTO labels VALUES (103, 'insertsort', 99);
INSERT INTO labels VALUES (104, 'mergesort', 99);
INSERT INTO labels VALUES (105, 'heapsort', 99);


--
-- Data for Name: pages; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO pages VALUES (2, 'login', 'prihlasenie sa do aplikacie', 'log_in.tpl', 'home', true);
INSERT INTO pages VALUES (1, 'home', 'domovska stranka', 'main.tpl', 'home', true);
INSERT INTO pages VALUES (4, 'task_list', 'zoznam úloh', 'admin.tpl', 'tasks', false);
INSERT INTO pages VALUES (3, 'logout', 'odhlasenie sa zo systemu', 'admin.tpl', 'home', false);
INSERT INTO pages VALUES (6, 'task_import', 'import úlohy', 'admin.tpl', 'tasks', false);
INSERT INTO pages VALUES (5, 'task_edit', 'editácia úlohy', 'admin_tab.tpl', 'tasks', false);
INSERT INTO pages VALUES (7, 'task_add', 'zadávanie novej úlohy', 'admin_tab.tpl', 'tasks', false);
INSERT INTO pages VALUES (10, 'tag_hierarchy', 'editácia tagov a stromov tagov', 'admin.tpl', 'tasks', false);
INSERT INTO pages VALUES (11, 'admin_courses', 'administracia predmetov', 'admin.tpl', 'admin', false);


--
-- Data for Name: pages_access; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO pages_access VALUES (1, 4, 1);
INSERT INTO pages_access VALUES (3, 3, 1);
INSERT INTO pages_access VALUES (4, 3, 2);
INSERT INTO pages_access VALUES (5, 5, 1);
INSERT INTO pages_access VALUES (6, 6, 1);
INSERT INTO pages_access VALUES (7, 7, 1);
INSERT INTO pages_access VALUES (8, 10, 1);
INSERT INTO pages_access VALUES (9, 11, 1);


--
-- Data for Name: pages_attached_files; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO pages_attached_files VALUES (1, 'include/js/taskEdit.js', 'javascript', 5);
INSERT INTO pages_attached_files VALUES (4, 'include/js/taskEdit.js', 'javascript', 7);
INSERT INTO pages_attached_files VALUES (5, 'include/js/tags.js', 'javascript', 10);
INSERT INTO pages_attached_files VALUES (6, 'include/js/tags.js', 'javascript', 5);
INSERT INTO pages_attached_files VALUES (7, 'include/js/sortable.js', 'javascript', 4);
INSERT INTO pages_attached_files VALUES (8, 'include/js/listing.js', 'javascript', 4);
INSERT INTO pages_attached_files VALUES (9, 'include/js/taskList.js', 'javascript', 4);
INSERT INTO pages_attached_files VALUES (11, 'include/js/listing.js', 'javascript', 11);
INSERT INTO pages_attached_files VALUES (12, 'css/listing.css', 'stylesheet', 11);
INSERT INTO pages_attached_files VALUES (13, 'include/js/adminCourses.js', 'javascript', 11);


--
-- Data for Name: sets; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: settings; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO settings VALUES (2, 'allowed_tags', '<b><i><strong>', 0);
INSERT INTO settings VALUES (3, 'task_list_text_length', '65', 0);


--
-- Data for Name: solutions; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO solutions VALUES (20, 3, '<pre><code>div2(0, 0).<br/>div2(s(0), 0).<br/>div2(s(s(X)),s(Y)):-div2(X,Y).<br/></code></pre>', '');
INSERT INTO solutions VALUES (19, 4, '<a href="files/tasks/Fact.java">Fact.java</a>', '');
INSERT INTO solutions VALUES (21, 1, '<a href="files/tasks/C412.java">C412.java</a>', '');


--
-- Data for Name: tasks; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO tasks VALUES (1, 'Polynom', 'Definujte triedu Polynom, ktorá reprezentuje polynom v N-tého stupňa s reálnymi koeficientami. Pre danú triedu definujte konštruktor Polynom(double[] p), metódu toString(), ktorá polynóm pretrasnformuje do textovej reprezentácie(za ktorú sa nehanbíte), a  metódu double hodnota(double x), ktorá vypočíta hodnotu polynómu v bode x., pomocka: <a href="files/tasks/C41.java">C41.java</a>', true);
INSERT INTO tasks VALUES (5, 'Prehliadač fotiek', 'Naprogramujte malý prehliadač fotiek (súborov .jpg) v jednom adresári. Funkcie: nasledujúca, predchádzajúca, zmaž, slide show.', true);
INSERT INTO tasks VALUES (6, 'Opitý námorník', 'Po kruhovom móle polomeru 10 metrov sa tacká opitý námorník. Začína v strede kruhového móla, a v každom kroku urobí krok náhodným smerom, náhodnej dĺžky, najviac však 1 meter. Ak sa opitý námorník vzdiali viac ako 10 metrov od stredu móla, padne do mora. Simulujte jeho pohyb, polohu, počet krokov. Pokúste sa ho zobraziť graficky.', true);
INSERT INTO tasks VALUES (7, 'Guličky v krabici', 'Graficky simulujte pohyb N guličiek v obdľžnikovej krabici, pričom každá má svoju rýchlosť, farbu a smer. Vždy po M časových jednotkách prihoďte do krabice ďalšiu guličku, a simulujete viac guličiek.', true);
INSERT INTO tasks VALUES (8, 'ArrayQueue', 'Implementujte triedu ArrayQueue, ktorá implementuje interface QueueInterface z prednášky tak, že front reprezentujete jednorozmerným poľom.', true);
INSERT INTO tasks VALUES (9, 'Lineárny zoznam', 'Pomocou triedy Node<E> z prednášky definujte triedu List<E>  reprezentujúcu lineárny zoznam s následujúcimi metódami:

<pre><code>

public List()



public List(E a[]) - konštrukcia zoznamu z poľa



public boolean isEmpty()



public E head() throws EmptyListException



public List<E> tail() throws EmptyListException



public void setHead(E newElem) throws EmptyListException



public String toString() - textová reprezentácia zoznamu



public int size() - jeho dlžka



public void append(List<E> y) - prilepí zoznam y na koniec aktuálneho zoznamu

</code></pre>', true);
INSERT INTO tasks VALUES (10, 'Riedke matice', 'Riedke matice sú matice veľkých rozmerov, ktorých len malá časť prvkov je nenulových. Navrhnite vhodnú reprezentáciu riedkych matíc (zložitosťou úmernú počtu nenulových elementov matice), tak aby ste vedeli implementovať základné operácie sčitovanie a násobenia riedkych matíc. Implementujte ich na vašej dátovej reprezentácii.', true);
INSERT INTO tasks VALUES (11, 'Veľké čísla', 'Navrhnite triedu, ktorá reprezentuje veľké čísla v desiatkovej sústave. Jedna z možností, že si ich pamätáte po cifrách. Implementujte metódy add a mult na sčítanie a násobenie takýchto čísiel.', true);
INSERT INTO tasks VALUES (12, 'Kasa', 'Váš program prečíta zo súboru <a href="files/tasks/ucet.txt">ucet.txt</a> informácie o tovare a cenách z vášho posledného nákupu v supermarkete. Oddeľovačom je ; pričom riadok obsahuje názov tovaru, počet kusov/váhu a celkovú cenu. Vypíšte zákazníkovi pekne naformátovaný pokladničný blok so súčtom a DPH. Ceny sa udávajú na 2 desatinné miesta zarovnané doprava.', true);
INSERT INTO tasks VALUES (13, 'Determinant', 'Vo stupnom <a href="files/tasks/matica3.txt">matica3.txt</a> súbore je matica celých čísel 3x3. Vypočítajte determinant tejto matice.', true);
INSERT INTO tasks VALUES (2, 'Invarianty', 'V programe <a href="files/tasks/order.c">order.c</a> nahraďte výrazy @VYRAZi skutočnými výrazmi tak, aby program fungoval a aby platili uvedené invarianty na miestach, kde sú uvedené. (Invariant je logická podmienka, ktorá musí v danom mieste programu platiť vždy, keď vykonávanie prechádza daným miestom - v niektorých jazykoch sa takéto podmienky dajú zapísať pomocou príkazu assert). ', true);
INSERT INTO tasks VALUES (3, 'Celočíselné delenie v Prologu', 'Definujte predikat div2(X,Y), ktory plati, ak Y = X div 2

', true);
INSERT INTO tasks VALUES (4, 'Obmedzený faktoriál', 'Napíšte program na výpočet faktoriálu, ktorý

<ul><li>nepoužíva príkaz priradenia</li>

    <li>nepoužíva násobenie</li>

    <li>nepoužíva žiadne číselne konštanty.</li>

</ul>', true);


--
-- Data for Name: tasks_labels; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO tasks_labels VALUES (16, 3, 96);
INSERT INTO tasks_labels VALUES (17, 3, 31);
INSERT INTO tasks_labels VALUES (18, 4, 9);
INSERT INTO tasks_labels VALUES (19, 1, 95);
INSERT INTO tasks_labels VALUES (20, 1, 9);
INSERT INTO tasks_labels VALUES (21, 1, 18);
INSERT INTO tasks_labels VALUES (22, 1, 86);
INSERT INTO tasks_labels VALUES (23, 1, 37);
INSERT INTO tasks_labels VALUES (24, 5, 18);
INSERT INTO tasks_labels VALUES (25, 5, 84);
INSERT INTO tasks_labels VALUES (26, 5, 95);
INSERT INTO tasks_labels VALUES (27, 5, 37);
INSERT INTO tasks_labels VALUES (28, 6, 95);
INSERT INTO tasks_labels VALUES (29, 6, 79);
INSERT INTO tasks_labels VALUES (30, 6, 37);


--
-- Data for Name: users; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO users VALUES (1, 'Peter', 'Jurčo', 'petejur@yahoo.com');
INSERT INTO users VALUES (2, 'Študent', 'Učenlivý', 'student@matfyz.sk');


--
-- Data for Name: users_in_groups; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO users_in_groups VALUES (1, 1, 1);
INSERT INTO users_in_groups VALUES (2, 2, 2);
INSERT INTO users_in_groups VALUES (3, 1, 1);


--
-- Name: authorization_groups_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY authorization_groups
    ADD CONSTRAINT authorization_groups_pkey PRIMARY KEY (id);


--
-- Name: authorization_login_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY "authorization"
    ADD CONSTRAINT authorization_login_key UNIQUE (login);


--
-- Name: boxes_page_id_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY boxes
    ADD CONSTRAINT boxes_page_id_key UNIQUE (page_id, name);


--
-- Name: categories_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY categories
    ADD CONSTRAINT categories_pkey PRIMARY KEY (id);


--
-- Name: courses_name_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY courses
    ADD CONSTRAINT courses_name_key UNIQUE (name);


--
-- Name: courses_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY courses
    ADD CONSTRAINT courses_pkey PRIMARY KEY (id);


--
-- Name: courses_terms_course_id_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY courses_terms
    ADD CONSTRAINT courses_terms_course_id_key UNIQUE (course_id, year, term);


--
-- Name: courses_terms_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY courses_terms
    ADD CONSTRAINT courses_terms_pkey PRIMARY KEY (id);


--
-- Name: dictionary_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY dictionary
    ADD CONSTRAINT dictionary_pkey PRIMARY KEY (id);


--
-- Name: labels_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY labels
    ADD CONSTRAINT labels_pkey PRIMARY KEY (id);


--
-- Name: pages_access_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY pages_access
    ADD CONSTRAINT pages_access_pkey PRIMARY KEY (id);


--
-- Name: pages_attached_files_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY pages_attached_files
    ADD CONSTRAINT pages_attached_files_pkey PRIMARY KEY (id);


--
-- Name: pages_name_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY pages
    ADD CONSTRAINT pages_name_key UNIQUE (name);


--
-- Name: pk_authorization_id; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY "authorization"
    ADD CONSTRAINT pk_authorization_id PRIMARY KEY (id);


--
-- Name: pk_boxes_id; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY boxes
    ADD CONSTRAINT pk_boxes_id PRIMARY KEY (id);


--
-- Name: pk_pages_id; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY pages
    ADD CONSTRAINT pk_pages_id PRIMARY KEY (id);


--
-- Name: pk_users_id; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY users
    ADD CONSTRAINT pk_users_id PRIMARY KEY (id);


--
-- Name: sets_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY sets
    ADD CONSTRAINT sets_pkey PRIMARY KEY (id);


--
-- Name: solutions_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY solutions
    ADD CONSTRAINT solutions_pkey PRIMARY KEY (id);


--
-- Name: tasks_labels_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY tasks_labels
    ADD CONSTRAINT tasks_labels_pkey PRIMARY KEY (id);


--
-- Name: tasks_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY tasks
    ADD CONSTRAINT tasks_pkey PRIMARY KEY (id);


--
-- Name: users_email_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY users
    ADD CONSTRAINT users_email_key UNIQUE (email);


--
-- Name: users_in_groups_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY users_in_groups
    ADD CONSTRAINT users_in_groups_pkey PRIMARY KEY (id);


--
-- Name: fki_; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX fki_ ON tasks_labels USING btree (task_id);


--
-- Name: fki_tasks_labels_label_id_labels_id; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX fki_tasks_labels_label_id_labels_id ON tasks_labels USING btree (label_id);


--
-- Name: authorization_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY "authorization"
    ADD CONSTRAINT authorization_user_id_fkey FOREIGN KEY (user_id) REFERENCES users(id);


--
-- Name: boxes_page_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY boxes
    ADD CONSTRAINT boxes_page_id_fkey FOREIGN KEY (page_id) REFERENCES pages(id);


--
-- Name: courses_terms_course_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY courses_terms
    ADD CONSTRAINT courses_terms_course_id_fkey FOREIGN KEY (course_id) REFERENCES courses(id);


--
-- Name: pages_access_group_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY pages_access
    ADD CONSTRAINT pages_access_group_id_fkey FOREIGN KEY (group_id) REFERENCES authorization_groups(id);


--
-- Name: pages_access_page_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY pages_access
    ADD CONSTRAINT pages_access_page_id_fkey FOREIGN KEY (page_id) REFERENCES pages(id);


--
-- Name: pages_attached_files_page_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY pages_attached_files
    ADD CONSTRAINT pages_attached_files_page_id_fkey FOREIGN KEY (page_id) REFERENCES pages(id);


--
-- Name: solutions_task_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY solutions
    ADD CONSTRAINT solutions_task_id_fkey FOREIGN KEY (task_id) REFERENCES tasks(id);


--
-- Name: tasks_labels_label_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY tasks_labels
    ADD CONSTRAINT tasks_labels_label_id_fkey FOREIGN KEY (label_id) REFERENCES labels(id);


--
-- Name: tasks_labels_task_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY tasks_labels
    ADD CONSTRAINT tasks_labels_task_id_fkey FOREIGN KEY (task_id) REFERENCES tasks(id);


--
-- Name: users_in_groups_authorization_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY users_in_groups
    ADD CONSTRAINT users_in_groups_authorization_id_fkey FOREIGN KEY (authorization_id) REFERENCES "authorization"(id);


--
-- Name: users_in_groups_group_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY users_in_groups
    ADD CONSTRAINT users_in_groups_group_id_fkey FOREIGN KEY (group_id) REFERENCES authorization_groups(id);


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- PostgreSQL database dump complete
--

