<?php

class page{
	private $id;
	private $include_path;
	private $styles_path;
	private $include_files = array();
	private $include_method;
	private $title;
	private $meta = array();
	private $template;
	private $module;
	private $tableRow;
	private $boxes = array(); //array of box object
	private $fixedBoxes = array(); //array of template names of fixed boxes
	private $historyOn = true; //store history in session?
	private $login_page; //URL of login page
	private $solid_boxes; //
	private $only_box = null; //we use it if we want to display only content of box and not whole page
	private $attachedFiles = array();
	
	public $isPublic = false;
	public $db;
	public $user;
	
	public function __construct(){
		$defaults = getPageDefaults(); //from config file
		foreach($defaults as $propertyName=>$propertyValue)
			$this->set($propertyName,$propertyValue);
		if($this->historyOn && is_array($_SESSION['history']) && ($_SESSION['history'][count($_SESSION['history'])-1]!=$_SERVER['REQUEST_URI'])) 
			$_SESSION['history'][] = $_SERVER['REQUEST_URI'];
		$this->db = new pgDB();	
		set_include_path($this->include_dir);
	}

	//This function allows to set any variable of page object	
	public function set($varName,$newValue,$varSubname=null){
		if(is_array($this->$varName) && $varSubname!=null)
			return $this->$varName[$varSubname] = $newValue;
		else 
			return $this->$varName = $newValue;		
	}
	
	public function get($varName,$varSubname=null){
		if(is_array($this->$varName) && $varSubname!=null){
			$tempArray = $this->$varName;
			return $tempArray[$varSubname];
		}
		else
			return $this->$varName;		
	}
	
	public function contentize($idOrName){
		//ked chceme zobrazit iba jeden box dame do parametra page hodnotu "showBox" 
		//a pridame parameter box_id s ID boxu, ktory chceme zobrazit
		if($idOrName == "showBox" && isset($_GET['box_id'])){
			$tblBoxes = new tblBoxes();
			$boxPage = new tblPages();
			if($tblBoxes->load($_GET['box_id']) && $boxPage->load($tblBoxes->get("page_id"))){
				$this->module = $boxPage->get("module");
				$this->isPublic = $boxPage->get("is_public");
				$this->tableRow = $boxPage;
				$this->only_box = $tblBoxes;
				return $this->authorize();
			}
			else
				return "nepodarilo sa nacitat BOX s ID: $_GET[box_id]";	
		}
		if($this->loadPage($idOrName)){
			if($this->authorize()){
				$this->loadAttachedFileNames();
				$this->loadBoxes();
				return true;
			}
		}
		else return false;
	}

	private function authorize(){
		//If user request access on private page and he isn't logged 
		if(!$this->isPublic && !$this->user->isLogged()){
			$this->redirect($this->login_page."&redirect=".urlencode($_SERVER['REQUEST_URI']));
		}
		//If logged user request access on private page and he hasn't permissions to go there 
		elseif(!$this->isPublic && !$this->user->hasAccess($this->tableRow->get('id')))
			die("<h1>Forbidden access...</h1>You don't have permissions to visit this page.");
		else
			return true;			
	}
	
	public function display(){
		$smarty = new Smarty();
		$smarty->assign('page', $this);
		if($this->only_box == null)
			$smarty->display($this->template);
		else{
			header('Content-Type: text/html; charset=utf-8'); 
			$className = $this->only_box->get("name")."Box";
			$boxToShow = new $className($this,$this->only_box);			
			$boxToShow->display();
		}
	}
	
	public function generateMetaTags(){
		if(count($this->meta)==0)
			return false;
		$out = $this->meta['description']!=""?"<meta name='description' content='".$this->meta['description']."'/>\n":"";
		$out .= $this->meta['charset']!=""?"<meta name='Content-Type' content='text/html; charset=".$this->meta['charset']."'/>\n":"";
		$out .= $this->meta['keywords']!=array()?"<meta name='keywords' content='".implode(',',$this->meta['keywords'])."'/>\n":"";
		$out .= $this->meta['author']!=""?"<meta name='author' content='".$this->meta['author']."'/>\n":"";
		$out .= $this->meta['copyright']!=""?"<meta name='copyright' content='".$this->meta['copyright']."'/>\n":"";
		$out .= $this->meta['robots']!=""?"<meta name='robots' content='".$this->meta['robots']."'/>\n":"";
		$out .= $this->meta['expires']!=""?"<meta http-equiv='expires' content='".$this->meta['expires']."'/>\n":"";
		$out .= $this->meta['language']!=""?"<meta http-equiv='content-language' content='".$this->meta['language']."'/>\n":"";
		return $out; 
	}
	
	/**
	 * Include all files from config file
	 */
	public function includeAll(){
		foreach($this->include_files as $file){
			//print "I included $file<br/>";
			$this->includeFile($file,$this->include_method);
		}
	}
	
	private function includeFile($file,$method){
		  switch($method){
		  	case "require_once":
		  		require_once($file);
		  		break;
		  	case "include_once":
		  		include_once($file);
		  		break;	 
		  	case "require":
		  		require($file);
		  		break;	 
		  	case "include":
		  		include($file);
		  		break;
		  	default: 
		  	    die("CHYBA: Nie je zadefinovany parameter 'include_method'");		 
		  }	
	}
	
	/**
	 * Attaches (writes attaching string) a files from pages_attached_files table
	 * Difference between this and IncludeAll method is that
	 * we can't use includeAll() to attach javascript or css files
	 */
	public function attachAllFiles(){
		foreach($this->attachedFiles as $type=>$files){
			foreach($files as $file_name){
				$this->attachFile($file_name,$type);
			}
		}
	}	
	
	private function attachFile($file_name,$type){
		switch($type){
			case "javascript":
				echo "<script type='text/javascript' src='$file_name'></script>";
			break;
			case "stylesheet":
				echo "<link href='$file_name' rel='stylesheet' type='text/css'>";
			break;
		}	
	}
	
	private function loadAttachedFileNames(){
		$attachedFiles = new pagesAttachedFilesTable;
		$rows = $attachedFiles->getMyRows("page_id = ".$this->tableRow->get('id'));
		if($rows){
		  foreach($rows as $row){
			$this->setAttachedFileName($row->get('file_type'),$row->get('file_name'));
		  }
		}
	}
	
	public function setAttachedFileName($file_type,$file_name){
		if(!isset($this->attachedFiles[$file_type]) || !in_array($file_name,$this->attachedFiles[$file_type]))
			$this->attachedFiles[$file_type][] = $file_name;
	}
	
	private function loadPage($idOrName){
		$tblPage = new tblPages();
		if(!$tblPage->load($idOrName))
			if(!$tblPage->loadWhere("name = '$idOrName'"))
				return false;
		$this->tableRow = $tblPage;
		$this->set("id",$this->tableRow->get("id"));
		if($this->tableRow->get("template"))
			$this->template = $this->tableRow->get("template");
		if($this->tableRow->get("module"))
			$this->module = $this->tableRow->get("module");		
		if($this->tableRow->get("is_public"))
			$this->isPublic = $this->tableRow->get("is_public");
		return true;
	}
	
	private function loadBoxes(){
		//loading solid boxes
		foreach($this->solid_boxes as $position=>$sbox_id){
			$tblBoxes = new tblBoxes();
			if($tblBoxes->load($sbox_id))
				$this->boxes[$position] = $tblBoxes;
		}
		
		//loading dynamic boxes
		$tblBoxes = new tblBoxes();
		if($myBoxes = $tblBoxes->getRows("SELECT * FROM boxes WHERE page_id = ".$this->tableRow->get("id")))
			foreach($myBoxes as $myBox)
				$this->boxes[$myBox->get('position')] = $myBox;
		//else print_r($tblBoxes->error);
		return true;	
	}
	
	public function displayBox($position){
		if(!array_key_exists($position,$this->boxes))
			$this->error("CHYBA: nedefinovany box $position",__FUNCTION__);
		$className = $this->boxes[$position]->get("name")."Box";
		$box = new $className($this,$this->boxes[$position]);
		return $box->display();
	} 
	
	/**
	 * In boxes, there can be a function setTitle(), which return value of <title></title> tag. 
	 * If it's found, set title of the page. 
	 */
	public function setTitleFromBoxes(){
		foreach($this->boxes as $box){
			$className = $box->get("name")."Box";
			if(method_exists($className,"setTitle")){
				$boxClass = new $className($this,$box);
				$this->title = $boxClass->setTitle();
			}
		}
	}
		
	//Function, like user clicking on browser's back button
	//can be implemented by javascript - less safer (user can disable JS)
	//or by sessions through PHP itself
	public function back($steps=1){
		//TODO: javascript version of back() function
		if(isset($_SESSION['history']) && count($_SESSION['history'])>=$steps) //if there some history and if is there enough backsteps...
			for($i=0; $i<$steps; $i++){
				unset($_SESSION['history'][count($_SESSION['history'])-1]);
			}
		$this->redirect(end($_SESSION['history']));	
	}
	
	
	public function redirect($url){
		if($url instanceof url) //url object (include/url.class.php)
			header("Location: ".$url->makeUrl());
		elseif(is_string($url))
			header("Location: ".$url);
		else 
			header("Location: index.php?id=1"); //TODO: odchytit chybu, ktora evidentne nastala a podat hlasku uzivatelovi
		exit;		
	}
	
  	/**
   	* Funkcia, ktora zaznamena chybu
   	*/
  	private function error($text,$function_name="none"){
  		global $error;
  		$error[get_class($this)][$function_name][] = array("text"=>$text,"params"=>"");
  	}

}


?>