<?php
class taskEditBox extends box {
	
	public function display(){
		$task = new tasksTable;
		$solution = new solutionsTable;
		$task_id = isset($_GET['task_id'])?$_GET['task_id']:$_POST['task_id']; 
		$mode = $task_id?'edit':'add';
		$errors = array();
		$message = array();
		if($mode == 'edit' && $task->load($task_id)){
			$solutions = $solution->getMyRows("task_id = ".$task->get('id'));
		}
		if($_POST['task_submit']){
			$errors = $this->checkValues($_POST);
			$data = $this->prepareValues($_POST);
			foreach($data as $key=>$value)
				$task->set($key,$value);
			if(!$errors){					
				if($mode == 'edit'){
					$task->set('id',$task_id);
					if(!$task->save()){
						$message = array("text"=>"Úlohu sa nepodarilo uložiť.",'type'=>"error");
					}
					else
						$message = array("text"=>"Úloha bola úspešne uložená.",'type'=>"success");
				}
				else{	
					if(!$task->add())
						$message = array("text"=>"Úlohu sa nepodarilo pridať.",'type'=>"error");
					else
						$this->page->redirect("index.php?page=task_edit&task_id=".$task->get('id')."&tab=2");
				}
			}
		}
		$this->add('mode',$mode);
		$this->add('task',$task);
		$this->add('solutions',$solutions);
		$this->add('errors',$errors);
		$this->add('message',$message);
		parent::display();
	}	
	
	private function checkValues($data){
		$error = array();
		if(!isset($data['task_name']) || trim($data['task_name']) == "")
			$error['task_name'] = "Musíte zadať názov úlohy";
		if(!isset($data['task_text']) || trim($data['task_text']) == "")
			$error['task_text'] = "Musíte zadať text úlohy";
		return $error;	
	}
	
	private function prepareValues($data){
		$data['name'] = trim($data['task_name']);
		$data['text'] = stripslashes($data['task_text']);
		return $data;
	}
	
	/**
	 * nastavi titulok stranky
	 */
	public function setTitle(){
		$task = new tasksTable;
		$task_id = isset($_GET['task_id'])?$_GET['task_id']:$_POST['task_id']; 
		$mode = $task_id?'edit':'add';
		if($mode == 'edit' && $task->load($task_id)){
			$title = $task->get('name');
		}
		return ($mode == 'edit')?"$title (Editácia úlohy)":"Zadávanie úlohy";
	}
}
?>