<?php
/***************************************************************
*  Copyright notice
*
*  (c) 2007  <>
*  All rights reserved
*
*  This script is part of the TYPO3 project. The TYPO3 project is
*  free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  The GNU General Public License can be found at
*  http://www.gnu.org/copyleft/gpl.html.
*
*  This script is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  This copyright notice MUST APPEAR in all copies of the script!
***************************************************************/

require_once(PATH_tslib.'class.tslib_pibase.php');


/**
 * Plugin 'partylist' for the 'partylist' extension.
 *
 * @author	 <>
 * @package	TYPO3
 * @subpackage	tx_partylist
 */
class tx_partylist_pi1 extends tslib_pibase {
	var $prefixId      = 'tx_partylist_pi1';		// Same as class name
	var $scriptRelPath = 'pi1/class.tx_partylist_pi1.php';	// Path to this script relative to the extension dir.
	var $extKey        = 'partylist';	// The extension key.
	var $pi_checkCHash = true;
	
	/**
	 * The main method of the PlugIn
	 *
	 * @param	string		$content: The PlugIn content
	 * @param	array		$conf: The PlugIn configuration
	 * @return	The content that is displayed on the website
	 */
	function main($content,$conf)	{
		$this->conf=$conf;
		$this->pi_setPiVarDefaults();
		$this->pi_loadLL();
		
		global $TSFE;
		$TSFE->set_no_cache();

	  if ($_GET["id"]=="partylist") {
	  
	  
	    if ($_GET["party"]=="add") {
	    
	     if (isset($_POST["submit_party"])) {
	    
	        $error=''; 
                  
         if ((($_POST["title"])!='') &&
         (($_POST["club"])!='') &&
         (($_POST["city"])!='') &&
         (($_POST["state"])!='') &&
         (($_POST["lineup"])!='') &&
         (($_POST["date"])!='') &&
         (($_POST["email"])!=''))
         
          
           {     
         
          
           
           
          if ((is_uploaded_file($_FILES["flyer"]["tmp_name"])) && (is_uploaded_file($_FILES["flyer_thumbnail"]["tmp_name"]))) {         
          
          $att = substr($_FILES["flyer"]["name"],strlen($_FILES["flyer"]["name"])-3,3);
          $size = GetImageSize($_FILES["flyer"]["tmp_name"]);
          
          $att_thumb = substr($_FILES["flyer_thumbnail"]["name"],strlen($_FILES["flyer_thumbnail"]["name"])-3,3);
          $size_thumb = GetImageSize($_FILES["flyer_thumbnail"]["tmp_name"]);
            
          
          if ($size_thumb[0]!="170") $error = '<strong>Chyba ! Náhľad flyeru musí mať 170 pixelov !</strong><br />';
            
  
          
          if (($att=='bmp' || $att=='jpg' || $att=='gif' || $att=='png') && 
             ($att_thumb=='bmp' || $att_thumb=='jpg' || $att_thumb=='gif' || $att_thumb=='png')) $atts = 'ok';
             else {
               $atts = 'error';
               $error.= '<strong>Chyba ! Zlý formát obrázku. Povolené sú typy BMP, JPG, GIF, PNG. Nahrajte obrázok v správnom formáte, alebo ponechajte položky Flyer a Flyer - náhľad voľné.</strong><br />';
               
           }    
             
             
          
          if (($atts == 'ok') && ($error==''))           
          
            {
                 
                 $datum = getdate();
                 $mesiac = $datum["mon"];
                 $rok = $datum["year"];
                 $den = $datum["mday"];
                 
                 //$filename = $_FILES["flyer"]["name"];
                 $filename = converttitle($_POST["title"]).$den.$mesiac.$rok.'.'.strtolower($att);
                 $filename_thumb = converttitle($_POST["title"]).$den.$mesiac.$rok.'_thumb.'.strtolower($att_thumb);
                 
                 $copy = move_uploaded_file($_FILES["flyer"]["tmp_name"], "uploads/tx_partylist/$filename");
                 $copy_thumb = move_uploaded_file($_FILES["flyer_thumbnail"]["tmp_name"], "uploads/tx_partylist/$filename_thumb");
                 $error_img = '';
                 
             
            } 

            
            
            
         } else $picture = 'no';
          
         $datum = strtotime($_POST["date"]);  


         if ($error=='') { 
           //hidden = novo pridana party, ktora treba unhidnut v type, ked ju niekto prida
           $query='insert into tx_partylist_partylist(pid,tstamp,crdate,cruser_id,deleted,hidden,title,club,city,state,lineup,date,timefrom,timeto,entry,website,email,flyer,flyerthumb,notincalendar)
                   values("6","'.$datum.'","'.$datum.'","1","0","1","'.$_POST["title"].'","'.$_POST["club"].'","'.$_POST["city"].'","'.$_POST["state"].'","'.$_POST["lineup"].'","'.$datum.'","'.$_POST["timefrom"].'","'.$_POST["timeto"].'","'.$_POST["entry"].'","'.$_POST["website"].'","'.$_POST["email"].'","'.$filename.'","'.$filename_thumb.'","0");';
         
                    
          $res = $GLOBALS['TYPO3_DB']->sql_query($query);
         }
         
       
         
      
	    
	    
	     }  else $error.= '<strong>Chyba ! Nevyplnili ste povinné (*) položky.</strong>';
	    
	    
	       
         if ($error!='') {
           $content.=$error;
           
         }  
         else { 
            $content.='<strong>Ďakujeme vám za pridanie akcie do nášho partylistu. Party bude zverejnená hneď po skontrolovaní, najneskôr do 24 hodín.</strong><br />';
           
           
            $email_content = 'Do partylistu bola pridana nova party - '.$_POST["title"];
            $to = 'macho@breaks.sk';
            $subject = 'breaks.sk - nova party v partyliste';
            $headers = "From: \"breaks.sk\" <news@breaks.sk>\n";
            mail($to, $subject, $email_content, $headers);
            
            
            
            $email_content = 'Vaša party bola zaznamenaná, ďakujeme. Po skontrolovaní administrátorom sa objaví v partyliste, najneskôr do 24 hodín.
              
              www.breaks.sk
            ';
            $to = $_POST["email"];
            $subject = 'breaks.sk - partylist';
            $headers = "From: \"breaks.sk\" <news@breaks.sk>\n";
            mail($to, $subject, $email_content, $headers);
            
         
         }
        }
        
	      $content.='<div class="nadpis">Pridaj party</div>';
	      
	      
	      $content.='<br /><br /><strong>Povinné položky sú označené hviezdičkou (*). Flyer a náhľad flyeru musia byť typu BMP, JPG, PNG alebo GIF. Náhľad musí mať šírku 170 pixelov. Dátum musí byť v tvare DD.MM.RRRR, teda napr. 15.09.2008. Po odoslaní formuláru bude party odoslaná na kontrolu. Po skontrolovaní sa objaví v partyliste najneskôr do 24 hodín. Zverejnené budú len akcie, ktoré sa týkajú breakbeatu, dnb, a podobných žánrov ako dubstep, grimme, jungle... Vo vlastnom záujme vyplňte položku e-mail pravdivo, ak by sme vás potrebovali kontaktovať. Plagáty, ktoré budú obsahovať logo breaks.sk ( <a href="http://www.breaks.sk/web/fileadmin/template/main/files/files/breakssklogo.zip">download - logo</a> ), budú zaradené medzi odporúčané akcie a do party kalendára. V prípade akýchkoľvek otázok ma kontaktujte na <a href="mailto:macho@breaks.sk">macho@breaks.sk</a></strong><br /><br /><br />';
	      
        $content.='<form action="partylist/add" method="post" enctype="multipart/form-data">';
        $content.='<div class="riadok"><div class="riadokleft">* Názov: </div><div class="riadokright"><input name="title" type="" /></div></div>';
        $content.='<div class="riadok"><div class="riadokleft">* Klub: </div><div class="riadokright"><input name="club" type="" /></div></div>';
        $content.='<div class="riadok"><div class="riadokleft">* Mesto: </div><div class="riadokright"><input name="city" type="city" /></div></div>';
        $content.='<div class="riadok"><div class="riadokleft">* Štát: </div><div class="riadokright"><input name="state" type="state" /></div></div>'; 
        $content.='<div class="riadok3"><div class="riadokleft">* Lineup: </div><div class="riadokright"><textarea name="lineup"></textarea></div></div>';
        $content.='<div class="riadok"><div class="riadokleft">* Dátum (dd.mm.rrrr): </div><div class="riadokright"><input name="date" type="text" /></div></div>';
        $content.='<div class="riadok"><div class="riadokleft">Začiatok: (hh:mm)</div><div class="riadokright"><input name="timefrom" type="text" /></textarea></div></div>';
        $content.='<div class="riadok"><div class="riadokleft">Koniec: (hh:mm)</div><div class="riadokright"><input name="timeto" type="text" /></div></div>';
        $content.='<div class="riadok"><div class="riadokleft">Vstupné: (sk)</div><div class="riadokright"><input name="entry" type="text" /></div></div>';
        $content.='<div class="riadok"><div class="riadokleft">Web: </div><div class="riadokright"><input name="web" type="text" /></div></div>';
        $content.='<div class="riadok"><div class="riadokleft">Flyer: </div><div class="riadokright"><input name="flyer" type="file" /></div></div>';
        $content.='<div class="riadok"><div class="riadokleft">Flyer - náhľad (šírka 170px) : </div><div class="riadokright"><input name="flyer_thumbnail" type="file" /></div></div>';
        $content.='<div class="riadok"><div class="riadokleft">* Kontaktný email: </div><div class="riadokright"><input name="email" type="text" /></div></div>';        
        $content.='<div class="riadok"><div class="riadokleft">&nbsp;</div><div class="riadokright"><input name="submit_party" id="submit_party" value="ok" type="submit" /></div></div>';
      
      
      
        $content.='</form>';
        
       }
      
       else {
       
       $year = $_GET["year"];
       $month = $_GET["month"];
       
       $datum = getdate();
       $mesiac = $datum["mon"];
       $rok = $datum["year"];
       
       
       if (($year=='') && ($month=='')) {
         $year = $rok;
         $month = $mesiac;
       }
       
       //mesiace, ktore maju 30 dni
       $shortermonths = array(
        "0" => "4",
        "1" => "6",
        "2" => "9",
        "3" => "11");
       
       //mesiace, ktore maju 31 dni
       $longermonths = array(
        "0" => "1",
        "1" => "3",
        "2" => "5",
        "3" => "7",
        "4" => "8",
        "5" => "10",
        "6" => "12");
       
       if ($month == 2) $endday = 29;
       if (in_array($month,$longermonths)) $endday = 31;
       if (in_array($month,$shortermonths)) $endday = 30;
       
       $start = strtotime('1.'.$month.'.'.$year);
       $end = strtotime($endday.'.'.$month.'.'.$year);
       
       $mesiace = array("1" => "Január",
       "2" => "Február",
       "3" => "Marec",
       "4" => "Apríl",
       "5" => "Máj",
       "6" => "Jún",
       "7" => "Júl",
       "8" => "August",
       "9" => "September",
       "10" => "Október",
       "11" => "November",
       "12" => "December");
       
       
      
       $query='select title, club, city, state, lineup, date, timefrom, timeto, entry, website, email, flyer, flyerthumb from tx_partylist_partylist where date>='.$start.' and date<='.$end.' and not deleted and not hidden order by date desc;';    
       $res = $GLOBALS['TYPO3_DB']->sql_query($query);
       
       $content.='<div class="headline">';
       $content.='<div class="headline_left">Partylist - '.$mesiace[$month].' '.$year.'</div>';
       
       
       $content.='<div class="headline_right">';
       $content.='<a class="partylist" href="partylist/'.$year.'/'.($month-1).'"> &lt;&lt;'.$mesiace[$month-1].'</a> ';
       if ($month<12)
       $content.='<a class="partylist" href="partylist/'.$year.'/'.($month+1).'">'.$mesiace[$month+1].' &gt;&gt;</a><br /><br />'; 
       $content.='</div>';
       $content.='</div>';
       
       $content.='<div class="partylinks">';
       $content.='<a class="addparty" href="partylist/add">Pridaj party</a>';
       
      
 
       $content.='</div>';
       
       
       
       
       
       
              
       for ($i=0; $i<$GLOBALS['TYPO3_DB']->sql_num_rows($res); $i++) {
           $row = $GLOBALS['TYPO3_DB']->sql_fetch_assoc($res);
           
           
           
             $content.='<div class="partylistsprava">';
             $content.='<div class="nadpisaperex">';
             if ($row["flyerthumb"]!='') $content.='<div class="nadpisimg"><a target="_blank" href="uploads/tx_partylist/'.$row["flyer"].'"><img src="uploads/tx_partylist/'.$row["flyerthumb"].'" alt="" width="170" /></a></div>';
             else $content.='<div class="nadpisimg"><img src="uploads/tx_partylist/noflyer.jpg" alt="" /></div>';
           
             $content.='<div class="party_data">';
             $content.='<div class="nadpisparty"><b>'.$row["title"].'</b></div>'; 
             $content.='<div class="perex">';
             $content.='<b>'.$row["club"].'</b><br />';
             $content.='<b>'.$row["city"].','.$row["state"].'</b><br />';
                          
             if ($row["timefrom"]=='') $row["timefrom"]='??';
             if ($row["timeto"]=='') $row["timeto"]='??';
           
             $content.='<b>'.date("d.m.Y",$row["date"]).'  '.$row["timefrom"].' - '.$row["timeto"].'</b><br />';
             $content.='<b>Entry:</b> '.$row["entry"].'<br />  <b>Web:</b><a class="partylist" href="'.$row["website"].'">'.$row["website"].'</a><br /><br /><br />';
                    
             $row["lineup"] = str_replace("\n","<br />",$row["lineup"]);
             $content.=$row["lineup"].'<br /><br />';
                    
             $content.='</div>';       
             $content.='</div>';
             $content.='</div>';
             $content.='</div>';
             //$content.='</div>';
           
       //   }
      }
	
	  }
		
	 }
		return $this->pi_wrapInBaseClass($content);
	}
}



	function converttitle($title) {
    $old = array("-"," ","ľ","š","č","ť","ž","ý","á","í","é","ú","ď","ň","ó");
    $new   = array("_","-", "l","s","c","t","z","y","a","i","e","u","d","n","o");
    
    $title = str_replace($old, $new, $title);
    $content = strtolower($title);
    return $content;
  }
  


if (defined('TYPO3_MODE') && $TYPO3_CONF_VARS[TYPO3_MODE]['XCLASS']['ext/partylist/pi1/class.tx_partylist_pi1.php'])	{
	include_once($TYPO3_CONF_VARS[TYPO3_MODE]['XCLASS']['ext/partylist/pi1/class.tx_partylist_pi1.php']);
}

?>
