﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.Security;

namespace AUDIOTEKA
{
    public partial class AlbumPage : System.Web.UI.Page
    {
        DataClassesDataContext _db = new DataClassesDataContext();

        protected void Page_Load(object sender, EventArgs e)
        {
            LabelMissing.Visible = false;
            LabelAlready.Visible = false;
            LabelSuccess.Visible = false;

            if (User.IsInRole("user"))
            {
                AlbumsGridView.Columns[4].Visible = true;
            }
            else
            {
                AlbumsGridView.Columns[4].Visible = false;
            }
        }

        protected void GridView_RowSelect(object sender, GridViewSelectEventArgs e)
        {
            if (User.IsInRole("user"))
            {
                PersonalAlbum addAlbum;
                int itemID = (int)AlbumsGridView.DataKeys[e.NewSelectedIndex].Value;

                int Acount = (from a in _db.Albums
                              where a.AlbumId.ToString() == itemID.ToString()
                              select a).Count();

                int PersonalAlbumcount = (from a in _db.PersonalAlbums
                                          where a.AlbumId.ToString() == itemID.ToString()
                                          select a).Count();

                if (Acount == 1)
                {
                    if (PersonalAlbumcount == 0)
                    {
                        addAlbum = new PersonalAlbum();
                        addAlbum.AlbumId = Convert.ToInt32(itemID.ToString());

                        MembershipUser myUser = Membership.GetUser();
                        Guid UserID = (Guid)myUser.ProviderUserKey;

                        addAlbum.UserId = UserID;

                        _db.PersonalAlbums.InsertOnSubmit(addAlbum);
                        _db.SubmitChanges();

                        LabelSuccess.Visible = true;

                    }
                    else
                    {
                        LabelAlready.Visible = true;
                    }

                }
                else
                {
                    LabelMissing.Visible = true;
                }


            }
        }

    }
}
