﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AUDIOTEKA
{
    public partial class ManageArtists : System.Web.UI.Page
    {
        DataClassesDataContext _db = new DataClassesDataContext();
        IEnumerable<Artist> _data;

        protected void LoadData()
        {
            _data = from artist in _db.Artists
                    orderby artist.LastName ascending
                    select artist;
        }

        protected void Page_Load(object sender, EventArgs e)
        {
            LoadData();

            ArtistGridView.DataSource = _data;
            ArtistGridView.DataBind();

            EditArtistExistsLabel.Visible = false;
            LabelRequired.Visible = false;

            if (!Page.IsPostBack)
            {
                EditPlaceHolder.Visible = false;
            }
        }

        protected void ArtistGridView_RowDelete(object sender, GridViewDeleteEventArgs e)
        {
            Artist ArtistToDelete;

            int ArtistId = (int)ArtistGridView.DataKeys[e.RowIndex].Value;

            ArtistToDelete = (from artist in _db.Artists
                              where artist.ArtistId == ArtistId
                              select artist).First();

            _db.Artists.DeleteOnSubmit(ArtistToDelete);
            _db.SubmitChanges();

            LoadData();
            ArtistGridView.DataSource = _data;
            ArtistGridView.DataBind();

        }

        protected void ArtistGridView_RowEdit(object sender, GridViewEditEventArgs e)
        {
            EditHiddenField.Value = "";

            int ArtistId = (int)ArtistGridView.DataKeys[e.NewEditIndex].Value;

            Artist ArtistToEdit = (from artist in _db.Artists
                                   where artist.ArtistId == ArtistId
                                   select artist).First();

            if (ArtistToEdit != null)
            {
                EditPlaceHolder.Visible = true;
                EditNadpis.InnerText = "Úprava autora: " + ArtistToEdit.FirstName + " " + ArtistToEdit.LastName;
                EditHiddenField.Value = ArtistId.ToString();
                EditArtistExistsLabel.Visible = false;

                EditFirstNameBox.Text = ArtistToEdit.FirstName;
                EditLastNameBox.Text = ArtistToEdit.LastName;
                EditInfoBox.Text = ArtistToEdit.Info;
                EditHomepageBox.Text = ArtistToEdit.HomePage;

            }
        }

        protected void ArtistGridView_PageChanged(object sender, GridViewPageEventArgs e)
        {
            ArtistGridView.PageIndex = e.NewPageIndex;
            ArtistGridView.DataBind();
        }

        protected void EditArtistButton_Click(object sender, EventArgs e)
        {

            //int ArtistCount = (from artist in _db.Artists
            //                   where artist.LastName == EditLastNameBox.Text & artist.FirstName == EditFirstNameBox.Text
            //                   select artist).Count();


            Artist ArtistToEdit = (from artist in _db.Artists
                                   where artist.ArtistId.ToString() == EditHiddenField.Value.ToString()
                                   select artist).First();

            if ((EditFirstNameBox.Text != "") | (EditLastNameBox.Text != ""))
            {
                if (ArtistToEdit != null)
                {
                    ArtistToEdit.FirstName = EditFirstNameBox.Text;
                    ArtistToEdit.LastName = EditLastNameBox.Text;
                    ArtistToEdit.Info = EditInfoBox.Text;
                    ArtistToEdit.HomePage = EditHomepageBox.Text;


                    _db.SubmitChanges();
                    EditPlaceHolder.Visible = false;
                }

                LoadData();
                ArtistGridView.DataSource = _data;
                ArtistGridView.DataBind();
                EditPlaceHolder.Visible = false;
            }
            else
            {
                LabelRequired.Visible = true;
            }
        }
    }
}
