﻿<%@ Page Title="" Language="C#" MasterPageFile="~/MasterDesign.Master" AutoEventWireup="true"
    CodeBehind="MyAlbumPage.aspx.cs" Inherits="AUDIOTEKA.MyAlbumPage" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainPlaceHolder" runat="server">
    <h2>
        Súkromný zoznam albumov
    </h2>
    <br />
    <asp:PlaceHolder ID="EditPlaceHolder" runat="server">
        <h3 id="EditNadpis" runat="server">
            Úprava informácií o albume
        </h3>
        <asp:Label ID="EditQualityLabel" runat="server" Text="Kvalita: " AssociatedControlID="EditQualityTextBox" />
        <asp:TextBox ID="EditQualityTextBox" runat="server" />
        &nbsp;
        <asp:Label ID="Label1" runat="server" ToolTip="1 - najhorsie, 5 - najlepsie" Text="Hodnotenie: "
            AssociatedControlID="EditDropDownList" />
        <asp:DropDownList Width="3em" ToolTip="Cim viac, tym lepsie" ID="EditDropDownList"
            runat="server">
            <asp:ListItem Text="1" Value="1" />
            <asp:ListItem Text="2" Value="2" />
            <asp:ListItem Text="3" Value="3" />
            <asp:ListItem Text="4" Value="4" />
            <asp:ListItem Text="5" Value="5" />
        </asp:DropDownList>
        &nbsp;
        <asp:Label AssociatedControlID="EditStorageTextBox" ID="EditStorageLabel" runat="server"
            Text="Storage: " />
        <asp:TextBox ID="EditStorageTextBox" runat="server" />&nbsp;&nbsp;
        <asp:Button ID="Button1" runat="server" Text="Uprav" OnClick="EditButton_Click" />
        <asp:HiddenField ID="EditHiddenField" runat="server" />
        <br />
        <asp:Label ID="EditAlbumExistsLabel" ForeColor="Red" runat="server" Text="Album neexistuje!"></asp:Label>
        <br />
        <br />
    </asp:PlaceHolder>
    <asp:GridView ID="MyAlbumsGridView" DataSourceID="MyAlbumsDataSource" AllowPaging="true"
        PageSize="15" DataKeyNames="AlbumId" runat="server" AutoGenerateColumns="false"
        OnRowDeleting="GridView_RowDeleting" OnSelectedIndexChanging="GridView_RowEdit">
        <RowStyle CssClass="rowA" />
        <AlternatingRowStyle CssClass="rowB" />
        <HeaderStyle CssClass="rowH" BorderColor="Black" ForeColor="White" Font-Underline="false" />
        <Columns>
            <asp:BoundField ItemStyle-BorderColor="black" DataField="ArtistName" HeaderText="Artist" />
            <asp:BoundField ItemStyle-BorderColor="black" DataField="Year" HeaderText="Year" />
            <asp:BoundField ItemStyle-BorderColor="black" DataField="AlbumName" HeaderText="Album" />
            <asp:BoundField ItemStyle-BorderColor="black" DataField="GenreName" HeaderText="Genre" />
            <asp:BoundField ItemStyle-BorderColor="black" DataField="Quality" HeaderText="Quality" />
            <asp:BoundField ItemStyle-BorderColor="black" DataField="Rating" HeaderText="Rating" />
            <asp:BoundField ItemStyle-BorderColor="black" DataField="StorageMedium" HeaderText="Storage" />
            <asp:CommandField ItemStyle-BorderColor="black" ShowSelectButton="true" ShowDeleteButton="true"
                SelectText="Uprav" DeleteText="Zmaž" HeaderText="Akcia" />
        </Columns>
        <PagerStyle BorderStyle="Solid" BorderWidth="1px" BorderColor="white" />
    </asp:GridView>
    <asp:ObjectDataSource TypeName="AUDIOTEKA.MyAlbumItems" SelectMethod="SelectPage"
        SelectCountMethod="SelectCount" ID="MyAlbumsDataSource" runat="server" EnablePaging="true"
        OnDeleting="ObjectDataSource_DeleteMethod" DeleteMethod="DeleteAlbum">
        <DeleteParameters>
            <asp:Parameter Name="AlbId" Type="Int32" />
        </DeleteParameters>
    </asp:ObjectDataSource>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="LeftPlaceHolder" runat="server">
</asp:Content>
