﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AUDIOTEKA
{
    public partial class NewAlbum : System.Web.UI.Page
    {
        DataClassesDataContext _db = new DataClassesDataContext();
        IEnumerable<Artist> _Artists;
        IEnumerable<Genre> _Genres;

        protected void Page_Load(object sender, EventArgs e)
        {
            FalseLabel.Visible = false;
            RequiredLabel.Visible = false;
            SuccessLabel.Visible = false;

            _Artists = from art in _db.Artists
                       select art;

            _Genres = from g in _db.Genres
                      select g;

            if (!Page.IsPostBack)
            {
                NewArtistDDList.DataSource = _Artists;
                NewArtistDDList.DataTextField = "LastName";
                NewArtistDDList.DataValueField = "ArtistId";
                NewArtistDDList.DataBind();

                NewGenreDDList.DataSource = _Genres;
                NewGenreDDList.DataTextField = "GenreName";
                NewGenreDDList.DataValueField = "GenreId";
                NewGenreDDList.SelectedValue = "105";
                NewGenreDDList.DataBind();
                NewAlbumNameTextBox.Text = "";
                NewYearTextBox.Text = "";
            }
        }
        protected void AddAlbumButton_Click(object sender, EventArgs e)
        {
            Album NewAlbum = new Album();

            if (NewAlbumNameTextBox.Text != "")
            {
                try
                {
                    NewAlbum.AlbumName = NewAlbumNameTextBox.Text;
                    NewAlbum.ArtistId = Convert.ToInt32(NewArtistDDList.SelectedValue);
                    NewAlbum.GenreId = Convert.ToInt32(NewGenreDDList.SelectedValue);
                    if (NewYearTextBox.Text == "")
                    {
                        NewAlbum.Year = null;
                    }
                    else
                    {
                        NewAlbum.Year = Convert.ToInt32(NewYearTextBox.Text);
                    }

                    _db.Albums.InsertOnSubmit(NewAlbum);
                    _db.SubmitChanges();

                    SuccessLabel.Visible = true;
                    NewGenreDDList.SelectedValue = "105";
                    NewAlbumNameTextBox.Text = "";
                    NewYearTextBox.Text = "";

                }
                catch (Exception)
                {
                    FalseLabel.Visible = true;
                }


            }
            else
            {
                RequiredLabel.Visible = true;
            }

        }
    }
}
