﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace AUDIOTEKA
{
    public class AlbumItem : Album
    {
        private string _ArtistName;

        private string _GenreName;

        public string ArtistName
        {
            get
            {
                return this._ArtistName;
            }
            set
            {
                if ((this._ArtistName != value))
                {
                    this._ArtistName = value;
                }
            }
        }
        public string GenreName
        {
            get
            {
                return this._GenreName;
            }
            set
            {
                if ((this._GenreName != value))
                {
                    this._GenreName = value;
                }
            }
        }

    }


    public class AlbumItems
    {
        public static IEnumerable<AlbumItem> Select()
        {
            DataClassesDataContext db = new DataClassesDataContext();

            return from alb in db.Albums

                   join g in db.Genres
                   on alb.GenreId equals g.GenreId

                   join art in db.Artists
                   on alb.ArtistId equals art.ArtistId

                   orderby art.LastName ascending

                   select new AlbumItem { ArtistName = art.FirstName + " " + art.LastName, GenreName = g.GenreName, AlbumId = alb.AlbumId, AlbumName = alb.AlbumName, ArtistId = alb.ArtistId, GenreId = alb.GenreId, PicturePresent = alb.PicturePresent, Year = alb.Year };
        }
        public static IEnumerable<AlbumItem> SelectPage(int startRowIndex, int maximumRows)
        {
            return Select().Skip(startRowIndex).Take(maximumRows);
        }
        public static int SelectCount()
        {
            return Select().Count();
        }
        public static void DeleteAlbum(int AlbId)
        {

        }
    }
}
