﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AUDIOTEKA
{
    public partial class GenresPage : System.Web.UI.Page
    {
        DataClassesDataContext _db = new DataClassesDataContext();
        IEnumerable<Genre> _data;

        protected void Page_Load(object sender, EventArgs e)
        {
            _data = from genre in _db.Genres
                    orderby genre.GenreName ascending
                    select genre;
            
            //_data.OrderBy<Genre, string>(o => o.GenreName);
            //_data = _data.OrderBy<Genre, string>(o => o.GenreName);

            GenresGridView.DataSource = _data;
            GenresGridView.DataBind();

        }

        protected void GenresGridView_PageChanged(object sender, GridViewPageEventArgs e)
        {
            GenresGridView.PageIndex = e.NewPageIndex;
            GenresGridView.DataBind();
        }

    }
}
