﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections;

namespace AUDIOTEKA
{
    public partial class ManageAlbums : System.Web.UI.Page
    {
        DataClassesDataContext _db = new DataClassesDataContext();
        IEnumerable<Artist> _Artists;
        IEnumerable<Genre> _Genres;



        protected void Page_Load(object sender, EventArgs e)
        {
            EditPlaceHolder.Visible = false;
            FalseLabel.Visible = false;
            RequiredLabel.Visible = false;
            SuccessLabel.Visible = false;

            _Artists = from art in _db.Artists
                       select art;

            _Genres = from g in _db.Genres
                      select g;


            if (!Page.IsPostBack)
            {
                EditArtistDDList.DataSource = _Artists;
                EditArtistDDList.DataTextField = "LastName";
                EditArtistDDList.DataValueField = "ArtistId";
                EditArtistDDList.DataBind();

                EditGenreDDList.DataSource = _Genres;
                EditGenreDDList.DataTextField = "GenreName";
                EditGenreDDList.DataValueField = "GenreId";
                EditGenreDDList.SelectedValue = "105";
                EditGenreDDList.DataBind();
                EditAlbumNameTextBox.Text = "";
                EditYearTextBox.Text = "";
            }
        }

        protected void AlbumGridView_RowDelete(object sender, GridViewDeleteEventArgs e)
        {
            Album AlbumToDelete;

            int AlbumId = (int)AlbumsGridView.DataKeys[e.RowIndex].Value;

            AlbumToDelete = (from album in _db.Albums
                             where album.AlbumId == AlbumId
                             select album).First();

            _db.Albums.DeleteOnSubmit(AlbumToDelete);
            _db.SubmitChanges();
        }

        protected void ObjectDataSource_DeleteMethod(object sender, ObjectDataSourceMethodEventArgs e)
        {
            IDictionary paramsFromPage = e.InputParameters;

            paramsFromPage.Remove("AlbId");
            paramsFromPage.Add("AlbId", (int)paramsFromPage["AlbumId"]);
            paramsFromPage.Remove("AlbumId");

        }

        //protected void ArtistGridView_RowEdit(object sender, GridViewEditEventArgs e)
        //{
        //    EditHiddenField.Value = "";

        //    int ArtistId = (int)ArtistGridView.DataKeys[e.NewEditIndex].Value;

        //    Artist ArtistToEdit = (from artist in _db.Artists
        //                           where artist.ArtistId == ArtistId
        //                           select artist).First();

        //    if (ArtistToEdit != null)
        //    {
        //        EditPlaceHolder.Visible = true;
        //        EditNadpis.InnerText = "Úprava autora: " + ArtistToEdit.FirstName + " " + ArtistToEdit.LastName;
        //        EditHiddenField.Value = ArtistId.ToString();
        //        EditArtistExistsLabel.Visible = false;

        //        EditFirstNameBox.Text = ArtistToEdit.FirstName;
        //        EditLastNameBox.Text = ArtistToEdit.LastName;
        //        EditInfoBox.Text = ArtistToEdit.Info;
        //        EditHomepageBox.Text = ArtistToEdit.HomePage;

        //    }
        //}

        //protected void ArtistGridView_PageChanged(object sender, GridViewPageEventArgs e)
        //{
        //    ArtistGridView.PageIndex = e.NewPageIndex;
        //    ArtistGridView.DataBind();
        //}

        //protected void EditArtistButton_Click(object sender, EventArgs e)
        //{

        //    //int ArtistCount = (from artist in _db.Artists
        //    //                   where artist.LastName == EditLastNameBox.Text & artist.FirstName == EditFirstNameBox.Text
        //    //                   select artist).Count();


        //    Artist ArtistToEdit = (from artist in _db.Artists
        //                           where artist.ArtistId.ToString() == EditHiddenField.Value.ToString()
        //                           select artist).First();

        //    if ((EditFirstNameBox.Text != "") | (EditLastNameBox.Text != ""))
        //    {
        //        if (ArtistToEdit != null)
        //        {
        //            ArtistToEdit.FirstName = EditFirstNameBox.Text;
        //            ArtistToEdit.LastName = EditLastNameBox.Text;
        //            ArtistToEdit.Info = EditInfoBox.Text;
        //            ArtistToEdit.HomePage = EditHomepageBox.Text;


        //            _db.SubmitChanges();
        //            EditPlaceHolder.Visible = false;
        //        }

        //        LoadData();
        //        ArtistGridView.DataSource = _data;
        //        ArtistGridView.DataBind();
        //        EditPlaceHolder.Visible = false;
        //    }
        //    else
        //    {
        //        LabelRequired.Visible = true;
        //    }
        //}
    }
}
